/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ModFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation overlayTexture;
    private final ResourceLocation renderOverlayTexture;
    private final int tintColor;

    public ModFluidType(FluidProperties properties) {
        super(properties.properties);
        this.stillTexture = properties.stillTexture;
        this.flowingTexture = properties.flowingTexture;
        this.overlayTexture = properties.overlayTexture;
        this.renderOverlayTexture = properties.renderOverlayTexture;
        this.tintColor = properties.tintColor;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ModFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return ModFluidType.this.flowingTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return ModFluidType.this.overlayTexture;
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return ModFluidType.this.renderOverlayTexture;
            }

            public int getTintColor() {
                return ModFluidType.this.tintColor;
            }
        });
    }

    public static class FluidProperties {
        private final FluidType.Properties properties;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        private ResourceLocation overlayTexture;
        private ResourceLocation renderOverlayTexture;
        private int tintColor = -1;

        public FluidProperties() {
            this(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_));
        }

        public FluidProperties(FluidType.Properties properties) {
            this.properties = properties;
        }

        public FluidProperties density(int density) {
            this.properties.density(density);
            return this;
        }

        public FluidProperties lightLevel(int lightLevel) {
            this.properties.lightLevel(lightLevel);
            return this;
        }

        public FluidProperties texture(ResourceLocation texture) {
            this.stillTexture(texture);
            this.flowingTexture(texture);
            return this;
        }

        public FluidProperties stillTexture(ResourceLocation stillTexture) {
            this.stillTexture = stillTexture;
            return this;
        }

        public FluidProperties flowingTexture(ResourceLocation flowingTexture) {
            this.flowingTexture = flowingTexture;
            return this;
        }

        public FluidProperties overlayTexture(ResourceLocation overlayTexture) {
            this.overlayTexture = overlayTexture;
            return this;
        }

        public FluidProperties renderOverlayTexture(ResourceLocation renderOverlayTexture) {
            this.renderOverlayTexture = renderOverlayTexture;
            return this;
        }

        public FluidProperties tintColor(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }
    }
}

