/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.api.fortron.FortronStorage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import one.util.streamex.StreamEx;

public class FrequencyGrid {
    private static FrequencyGrid CLIENT_INSTANCE = new FrequencyGrid();
    private static FrequencyGrid SERVER_INSTANCE = new FrequencyGrid();
    private final Set<FortronStorage> frequencyGrid = new HashSet<FortronStorage>();

    public <T extends FortronStorage> void register(T fortron) {
        BlockPos pos = fortron.getOwner().m_58899_();
        this.frequencyGrid.removeIf(frequency -> {
            BlockEntity owner = frequency.getOwner();
            return frequency == null || owner.m_58901_() || owner.m_58899_().equals((Object)pos);
        });
        this.frequencyGrid.add(fortron);
    }

    public static FrequencyGrid instance() {
        return FrequencyGrid.instance(EffectiveSide.get().isClient());
    }

    public static FrequencyGrid instance(boolean client) {
        return client ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    public void unregister(FortronStorage tileEntity) {
        this.frequencyGrid.remove(tileEntity);
        this.cleanUp();
    }

    public Set<FortronStorage> get() {
        return this.frequencyGrid;
    }

    public Set<FortronStorage> get(int frequency) {
        return ((StreamEx)StreamEx.of(this.get()).filter(fortron -> fortron != null && !fortron.getOwner().m_58901_() && fortron.getFrequency() == frequency)).toSet();
    }

    public List<FortronStorage> get(Level level, Vec3i position, int radius, int frequency) {
        return ((StreamEx)StreamEx.of(this.get(frequency)).filter(fortron -> {
            BlockEntity owner = fortron.getOwner();
            return owner.m_58904_() == level && position.m_123314_((Vec3i)owner.m_58899_(), (double)radius);
        })).toList();
    }

    public void cleanUp() {
        this.frequencyGrid.removeIf(fortron -> fortron == null || fortron.getOwner().m_58901_());
    }

    public static void reinitiate() {
        CLIENT_INSTANCE = new FrequencyGrid();
        SERVER_INSTANCE = new FrequencyGrid();
    }
}

