/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.su5ed.mffs.render.particle.ParticleColor;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamParticle
extends Particle {
    private static final ResourceLocation FORTRON_TEXTURE = new ResourceLocation("mffs", "textures/particle/fortron.png");
    private static final int ROTATION_SPEED = 20;
    private static final boolean PULSE = true;
    private final float length;
    private final float rotYaw;
    private final float rotPitch;
    private final float prevYaw;
    private final float prevPitch;
    private float prevSize;

    public BeamParticle(ClientLevel level, Vec3 start, Vec3 target, ParticleColor color, int lifetime) {
        super(level, start.m_7096_(), start.m_7098_(), start.m_7094_(), 0.0, 0.0, 0.0);
        this.m_107253_(color.getRed(), color.getGreen(), color.getBlue());
        this.m_107250_(0.02f, 0.02f);
        this.m_107259_(new AABB(start, target));
        this.m_107257_(lifetime);
        this.f_107215_ = this.f_107209_ - target.m_7096_();
        this.f_107216_ = this.f_107210_ - target.m_7098_();
        this.f_107217_ = this.f_107211_ - target.m_7094_();
        this.length = (float)start.m_82554_(target);
        this.rotYaw = (float)(Math.atan2(this.f_107215_, this.f_107217_) * 180.0 / Math.PI);
        double destX = Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_);
        this.rotPitch = (float)(Math.atan2(this.f_107216_, destX) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Matrix4f mat = new Matrix4f();
        mat.identity();
        int deg = 18;
        float rot = (float)(this.f_107208_.m_46467_() % (long)deg * 20L) + 20.0f * partialTicks;
        float size = 1.0f;
        size = Math.min((float)this.f_107224_ / 4.0f, 1.0f);
        size = Mth.m_14179_((float)partialTicks, (float)this.prevSize, (float)size);
        float opacity = 0.5f;
        if (this.f_107225_ - this.f_107224_ <= 4) {
            opacity = 0.5f - (float)(4 - (this.f_107225_ - this.f_107224_)) * 0.1f;
        }
        float tickSlide = (float)this.f_107208_.m_46467_() + partialTicks;
        float vOffset = -tickSlide * 0.2f - (float)Mth.m_14143_((float)(-tickSlide * 0.1f));
        Vec3 vec3 = renderInfo.m_90583_();
        float xx = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float yy = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float zz = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        mat.translate((Vector3fc)new Vector3f(xx, yy, zz));
        float ry = Mth.m_14179_((float)partialTicks, (float)this.prevYaw, (float)this.rotYaw);
        float rp = Mth.m_14179_((float)partialTicks, (float)this.prevPitch, (float)this.rotPitch);
        mat.rotate((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        mat.rotate((Quaternionfc)Axis.f_252393_.m_252977_(180.0f + ry));
        mat.rotate((Quaternionfc)Axis.f_252529_.m_252977_(rp));
        float xNegMin = -0.15f * size;
        float xNegMax = -0.15f * size;
        float xPosMin = 0.15f * size;
        float xPosMax = 0.15f * size;
        float yMax = this.length * size;
        Vector3f[] vectors = new Vector3f[]{new Vector3f(xNegMax, yMax, 0.0f), new Vector3f(xNegMin, 0.0f, 0.0f), new Vector3f(xPosMin, 0.0f, 0.0f), new Vector3f(xPosMax, yMax, 0.0f)};
        float u0 = 0.0f;
        float u1 = 1.0f;
        int brightness = 0xF000F0;
        mat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(rot));
        for (int i = 0; i < 3; ++i) {
            float v0 = -1.0f + vOffset + (float)i / 3.0f;
            float v1 = this.length * size + v0;
            mat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(60.0f));
            buffer.m_252986_(mat, vectors[0].x(), vectors[0].y(), vectors[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, opacity).m_85969_(brightness).m_5752_();
            buffer.m_252986_(mat, vectors[1].x(), vectors[1].y(), vectors[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, opacity).m_85969_(brightness).m_5752_();
            buffer.m_252986_(mat, vectors[2].x(), vectors[2].y(), vectors[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, opacity).m_85969_(brightness).m_5752_();
            buffer.m_252986_(mat, vectors[3].x(), vectors[3].y(), vectors[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, opacity).m_85969_(brightness).m_5752_();
        }
        this.prevSize = size;
    }

    public ParticleRenderType m_7556_() {
        return BeamParticleRenderType.INSTANCE;
    }

    public static class BeamParticleRenderType
    implements ParticleRenderType {
        public static final BeamParticleRenderType INSTANCE = new BeamParticleRenderType();

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FORTRON_TEXTURE);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }
    }
}

