/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.render.ModRenderType;
import dev.su5ed.mffs.render.OffscreenRenderTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class RenderPostProcessor {
    public static final RenderStateShard.OutputStateShard GLITCH_TARGET = new RenderStateShard.OutputStateShard("mffs:glitch_target", () -> {
        if (enableGlitchEffect) {
            glitchRenderTarget.m_83947_(false);
            RenderSystem.depthMask((boolean)true);
        } else {
            ModRenderType.TRANSLUCENT_TARGET_NO_DEPTH_MASK.m_110185_();
        }
    }, () -> {
        if (enableGlitchEffect) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        } else {
            ModRenderType.TRANSLUCENT_TARGET_NO_DEPTH_MASK.m_110188_();
        }
    });
    private static final ResourceLocation NOISE_SEED = MFFSMod.location("textures/model/noise.png");
    static RenderTarget glitchRenderTarget;
    private static Matrix4f shaderOrthoMatrix;
    private static PostPass postProcessPass;
    private static boolean enableGlitchEffect;

    public static void initRenderTarget() {
        enableGlitchEffect = (Boolean)MFFSConfig.CLIENT.enableProjectorModeGlitch.get();
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderTarget mainRenderTarget = minecraft.m_91385_();
            Window window = minecraft.m_91268_();
            glitchRenderTarget = new OffscreenRenderTarget(window.m_85441_(), window.m_85442_());
            glitchRenderTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)mainRenderTarget.f_83915_, 0.0f, (float)mainRenderTarget.f_83916_, 0.1f, 1000.0f);
        }
    }

    public static void reloadPostProcessPass() {
        enableGlitchEffect = (Boolean)MFFSConfig.CLIENT.enableProjectorModeGlitch.get();
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderTarget mainRenderTarget = minecraft.m_91385_();
            if (postProcessPass != null) {
                postProcessPass.close();
            }
            try {
                postProcessPass = new PostPass(minecraft.m_91098_(), "mffs:glitch_blit", glitchRenderTarget, mainRenderTarget);
                postProcessPass.m_253214_(shaderOrthoMatrix);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void resizeDisplay() {
        if (enableGlitchEffect) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderTarget mainRenderTarget = minecraft.m_91385_();
            Window window = minecraft.m_91268_();
            if (glitchRenderTarget != null) {
                glitchRenderTarget.m_83941_(window.m_85441_(), window.m_85442_(), Minecraft.f_91002_);
            }
            shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)mainRenderTarget.f_83915_, 0.0f, (float)mainRenderTarget.f_83916_, 0.1f, 1000.0f);
            if (postProcessPass != null) {
                postProcessPass.m_253214_(shaderOrthoMatrix);
            }
        }
    }

    public static void prepareRender() {
        if (enableGlitchEffect) {
            glitchRenderTarget.m_83954_(Minecraft.f_91002_);
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    }

    public static void process(int ticks) {
        if (enableGlitchEffect) {
            RenderPostProcessor.process(postProcessPass, ticks);
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    }

    private static void process(PostPass pass, float time) {
        EffectInstance effect = pass.m_110074_();
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        float width = pass.f_110053_.f_83915_;
        float height = pass.f_110053_.f_83916_;
        float farPlane = 500.0f;
        pass.f_110052_.m_83970_();
        RenderSystem.viewport((int)0, (int)0, (int)((int)width), (int)((int)height));
        effect.m_108954_("DiffuseSampler", () -> ((RenderTarget)pass.f_110052_).m_83975_());
        effect.m_108954_("NoiseSampler", () -> minecraft.f_90987_.m_118506_(NOISE_SEED).m_117963_());
        effect.m_108954_("DepthSampler", () -> ((RenderTarget)pass.f_110052_).m_83980_());
        effect.m_108960_("ProjMat").m_5679_(shaderOrthoMatrix);
        effect.m_108960_("InSize").m_7971_((float)pass.f_110052_.f_83915_, (float)pass.f_110052_.f_83916_);
        effect.m_108960_("OutSize").m_7971_(width, height);
        effect.m_108960_("Time").m_5985_(time);
        effect.m_108960_("ScreenSize").m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        effect.m_108966_();
        pass.f_110053_.m_83947_(false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferbuilder.m_5483_(0.0, 0.0, (double)farPlane).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, (double)farPlane).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, (double)farPlane).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)height, (double)farPlane).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        effect.m_108965_();
        pass.f_110053_.m_83970_();
        pass.f_110052_.m_83963_();
    }

    private RenderPostProcessor() {
    }
}

