/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.render.LazyRenderer;
import dev.su5ed.mffs.render.ModRenderType;
import dev.su5ed.mffs.render.RenderTickHandler;
import dev.su5ed.mffs.render.model.ProjectorRotorModel;
import dev.su5ed.mffs.setup.ModClientSetup;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public static final ResourceLocation PROJECTOR_OFF_TEXTURE = new ResourceLocation("mffs", "textures/model/projector_off.png");
    public static final ResourceLocation PROJECTOR_ON_TEXTURE = new ResourceLocation("mffs", "textures/model/projector_on.png");
    private final ModelPart rotor;
    private final Function<ModelLayerLocation, ModelPart> modelPartCache;
    private final Function<BlockEntity, HoloRenderer> holoRenderer;

    public ProjectorRenderer(BlockEntityRendererProvider.Context context) {
        this.rotor = context.m_173582_(ProjectorRotorModel.LAYER_LOCATION);
        this.modelPartCache = Util.m_143827_(arg_0 -> ((BlockEntityRendererProvider.Context)context).m_173582_(arg_0));
        this.holoRenderer = Util.m_143827_(HoloRenderer::new);
    }

    public void render(ProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderRotor(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        blockEntity.getMode().ifPresent(mode -> {
            RenderTickHandler.addTransparentRenderer(ModRenderType.STANDARD_TRANSLUCENT_TRIANGLE, this.holoRenderer.apply(blockEntity));
            ModClientSetup.renderLazy(blockEntity.getModeStack().m_41720_(), blockEntity, this.modelPartCache);
        });
    }

    private void renderRotor(ProjectorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ResourceLocation texture = blockEntity.isActive() ? PROJECTOR_ON_TEXTURE : PROJECTOR_OFF_TEXTURE;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, -0.75, 0.5);
        float activePartial = blockEntity.isActive() ? partialTick : 0.0f;
        poseStack.m_252781_(Axis.f_252392_.m_252977_(((float)blockEntity.getAnimation() + activePartial) * (float)blockEntity.getAnimationSpeed()));
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        this.rotor.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    private static class HoloRenderer
    implements LazyRenderer {
        private final BlockEntity be;
        private final Vec3 centerPos;

        public HoloRenderer(BlockEntity be) {
            this.be = be;
            this.centerPos = Vec3.m_82512_((Vec3i)be.m_58899_());
        }

        @Override
        public void render(PoseStack poseStack, VertexConsumer buffer, int ticks, float partialTick) {
            poseStack.m_85836_();
            poseStack.m_85837_(this.centerPos.f_82479_, this.centerPos.f_82480_, this.centerPos.f_82481_);
            Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20182_();
            BlockPos bePos = this.be.m_58899_();
            double xDifference = playerPos.f_82479_ - ((double)bePos.m_123341_() + 0.5);
            double zDifference = playerPos.f_82481_ - ((double)bePos.m_123343_() + 0.5);
            float rotation = (float)Math.toDegrees(Math.atan2(zDifference, xDifference));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation + 27.0f));
            float height = 2.0f;
            float width = 2.0f;
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_6122_(72, 198, 255, 255).m_5752_();
            buffer.m_252986_(mat, -0.866f * width, height, -0.5f * width).m_6122_(0, 0, 0, 0).m_5752_();
            buffer.m_252986_(mat, 0.866f * width, height, -0.5f * width).m_6122_(0, 0, 0, 0).m_5752_();
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_6122_(72, 198, 255, 255).m_5752_();
            buffer.m_252986_(mat, 0.866f * width, height, -0.5f * width).m_6122_(0, 0, 0, 0).m_5752_();
            buffer.m_252986_(mat, 0.0f, height, width).m_6122_(0, 0, 0, 0).m_5752_();
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_6122_(72, 198, 255, 255).m_5752_();
            buffer.m_252986_(mat, 0.0f, height, width).m_6122_(0, 0, 0, 0).m_5752_();
            buffer.m_252986_(mat, -0.866f * width, height, -0.5f * width).m_6122_(0, 0, 0, 0).m_5752_();
            poseStack.m_85849_();
        }

        @Override
        @Nullable
        public Vec3 centerPos() {
            return this.centerPos;
        }
    }
}

