/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.su5ed.mffs.item.CustomProjectorModeItem;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.network.StructureDataRequestPacket;
import dev.su5ed.mffs.render.BlockHighlighter;
import dev.su5ed.mffs.setup.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import one.util.streamex.StreamEx;

@Mod.EventBusSubscriber(modid="mffs", value={Dist.CLIENT})
public final class CustomProjectorModeClientHandler {
    private static final float MIN_ALPHA = 0.1f;
    private static final float MAX_ALPHA = BlockHighlighter.LIGHT_RED.alpha();
    private static final int PERIOD_TICKS = 30;
    private static final Map<ResourceKey<Level>, Map<String, VoxelShape>> STRUCTURE_SHAPES = new HashMap<ResourceKey<Level>, Map<String, VoxelShape>>();

    public static VoxelShape getOrRequestShape(ItemStack stack, Level level) {
        String id = stack.m_41784_().m_128461_("pattern_id");
        ResourceKey key = level.m_46472_();
        Map<String, VoxelShape> map = STRUCTURE_SHAPES.get(key);
        if (map == null || !map.containsKey(id)) {
            Network.INSTANCE.sendToServer((Object)new StructureDataRequestPacket(id));
            CustomProjectorModeClientHandler.setShape((ResourceKey<Level>)key, id, null);
            return null;
        }
        return map.get(id);
    }

    public static void setShape(ResourceKey<Level> level, String id, VoxelShape shape) {
        Map map = STRUCTURE_SHAPES.computeIfAbsent(level, l -> new HashMap());
        map.put(id, shape);
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            Minecraft minecraft = Minecraft.m_91087_();
            StreamEx.of((Object[])new ItemStack[]{minecraft.f_91074_.m_21205_(), minecraft.f_91074_.m_21206_()}).findFirst(stack -> stack.m_150930_((Item)ModItems.CUSTOM_MODE.get())).ifPresent(stack -> {
                VoxelShape shape;
                PoseStack pose = new PoseStack();
                Vec3 cameraPos = event.getCamera().m_90583_();
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128441_("primary_point")) {
                    BlockPos primary = CustomProjectorModeItem.getPos(tag, "primary_point");
                    BlockHighlighter.highlightBlock(pose, cameraPos, primary, BlockHighlighter.LIGHT_GREEN);
                    if (tag.m_128441_("secondary_point")) {
                        BlockPos secondary = CustomProjectorModeItem.getPos(tag, "secondary_point");
                        BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED);
                        BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                    } else {
                        HitResult patt3705$temp = minecraft.f_91077_;
                        if (patt3705$temp instanceof BlockHitResult) {
                            BlockHitResult blockHitResult = (BlockHitResult)patt3705$temp;
                            BlockPos secondary = blockHitResult.m_82425_();
                            float alpha = 0.1f + (MAX_ALPHA - 0.1f) * 0.5f * Mth.m_14154_((float)(Mth.m_14031_((float)(0.20943953f * (float)event.getRenderTick())) + 1.0f));
                            BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED.withAlpha(alpha));
                            BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                        }
                    }
                }
                if (tag.m_128441_("pattern_id") && (shape = CustomProjectorModeClientHandler.getOrRequestShape(stack, (Level)minecraft.f_91073_)) != null) {
                    BlockHighlighter.highlightArea(pose, cameraPos, shape, null);
                }
            });
        }
    }

    private CustomProjectorModeClientHandler() {
    }
}

