/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.menu;

import dev.su5ed.mffs.blockentity.FortronBlockEntity;
import dev.su5ed.mffs.setup.ModItems;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.DataSlotWrapper;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import dev.su5ed.mffs.util.inventory.SlotInventory;
import dev.su5ed.mffs.util.inventory.SlotInventoryFilter;
import dev.su5ed.mffs.util.loot.MenuInventoryTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public abstract class FortronMenu<T extends FortronBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    protected final Player player;
    protected final IItemHandler playerInventory;
    private final IItemHandler itemHandler;
    private final List<Slot> hotBarSlots = new ArrayList<Slot>();
    private final List<Slot> playerInventorySlots = new ArrayList<Slot>();
    private final List<Slot> blockEntitySlots = new ArrayList<Slot>();
    private Runnable frequencyChangeListener;
    private boolean isRemoteAccess;

    protected FortronMenu(@Nullable MenuType<?> type, BlockEntityType<T> blockEntityType, int containerId, BlockPos pos, Player player, Inventory playerInventory) {
        super(type, containerId);
        this.player = player;
        this.blockEntity = (FortronBlockEntity)player.m_20193_().m_141902_(pos, blockEntityType).orElseThrow();
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.trackPower();
        this.itemHandler = (IItemHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalArgumentException("IItemHandler capability not found"));
        this.m_38893_(new AdvancementContainerListener());
    }

    protected Slot addInventorySlot(Slot slot) {
        Slot ret = this.m_38897_(slot);
        this.blockEntitySlots.add(ret);
        return ret;
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.isRemoteAccess = remoteAccess;
    }

    public void setFrequencyChangeListener(Runnable frequencyChangeListener) {
        this.frequencyChangeListener = frequencyChangeListener;
    }

    public void triggerMenuAdvancement() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean active = ((FortronBlockEntity)this.blockEntity).isActive();
            ((MenuInventoryTrigger)((Object)ModObjects.MENU_INVENTORY_TRIGGER.get())).trigger(serverPlayer, active, this.itemHandler);
        }
    }

    public boolean m_6875_(Player player) {
        return (Boolean)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()).m_39299_((level, pos) -> (!this.isRemoteAccess || player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.REMOTE_CONTROLLER_ITEM.get())) && level.m_8055_(pos).m_60713_(this.blockEntity.m_58900_().m_60734_()), (Object)true);
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            Slot slot = this.m_38853_(slotId);
            if (slot instanceof SlotInventoryFilter && clickType == ClickType.PICKUP) {
                ItemStack stack = this.m_142621_();
                if (button == 0) {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else {
                    slot.m_5852_(ItemStack.f_41583_);
                }
                return;
            }
            this.triggerMenuAdvancement();
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (this.blockEntitySlots.contains(slot) ? !ModUtil.moveItemStackTo(slotStack, this.hotBarSlots) && !ModUtil.moveItemStackTo(slotStack, this.playerInventorySlots) : !ModUtil.moveItemStackTo(slotStack, this.blockEntitySlots)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    protected void layoutPlayerInventorySlots(int x, int y) {
        TriFunction factory = (index, slotX, slotY) -> new SlotItemHandler(this.playerInventory, index.intValue(), slotX.intValue(), slotY.intValue());
        this.playerInventorySlots.addAll(this.addSlotBox(9, x, y, 9, 18, 3, 18, (TriFunction<Integer, Integer, Integer, Slot>)factory));
        this.hotBarSlots.addAll(this.addSlotRange(0, x, y += 58, 9, 18, (TriFunction<Integer, Integer, Integer, Slot>)factory));
    }

    protected void addInventorySlotBox(int x, int y, int horAmount, int verAmount, List<InventorySlot> slots) {
        this.blockEntitySlots.addAll(this.addSlotBox(x, y, horAmount, verAmount, slots));
    }

    protected List<Slot> addSlotBox(int x, int y, int horAmount, int verAmount, List<InventorySlot> slots) {
        return this.addSlotBox(0, x, y, horAmount, 18, verAmount, 18, (TriFunction<Integer, Integer, Integer, Slot>)((TriFunction)(idx, slotX, slotY) -> new SlotInventory((InventorySlot)slots.get((int)idx), (int)slotX, (int)slotY)));
    }

    protected List<Slot> addSlotBox(int index, int x, int y, int horAmount, int dx, int verAmount, int dy, TriFunction<Integer, Integer, Integer, Slot> factory) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int j = 0; j < verAmount; ++j) {
            slots.addAll(this.addSlotRange(index, x, y, horAmount, dx, factory));
            index += horAmount;
            y += dy;
        }
        return slots;
    }

    protected void addInventorySlotRange(int index, int x, int y, int amount, int dx, TriFunction<Integer, Integer, Integer, Slot> factory) {
        this.blockEntitySlots.addAll(this.addSlotRange(index, x, y, amount, dx, factory));
    }

    protected List<Slot> addSlotRange(int index, int x, int y, int amount, int dx, TriFunction<Integer, Integer, Integer, Slot> factory) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int i = 0;
        while (i < amount) {
            slots.add(this.m_38897_((Slot)factory.apply((Object)index, (Object)x, (Object)y)));
            ++i;
            x += dx;
            ++index;
        }
        return slots;
    }

    private void trackPower() {
        this.addIntDataSlot(((FortronBlockEntity)this.blockEntity).fortronStorage::getStoredFortron, ((FortronBlockEntity)this.blockEntity).fortronStorage::setStoredFortron);
        this.addIntDataSlot(((FortronBlockEntity)this.blockEntity).fortronStorage::getFrequency, frequency -> {
            ((FortronBlockEntity)this.blockEntity).fortronStorage.setFrequency(frequency);
            if (this.frequencyChangeListener != null) {
                this.frequencyChangeListener.run();
            }
        });
    }

    protected void addIntDataSlot(IntSupplier gettter, IntConsumer setter) {
        this.addDataSlot(() -> gettter.getAsInt() & 0xFFFF, value -> {
            int current = gettter.getAsInt() & 0xFFFF0000;
            setter.accept(current + (value & 0xFFFF));
        });
        this.addDataSlot(() -> gettter.getAsInt() >> 16 & 0xFFFF, value -> {
            int current = gettter.getAsInt() & 0xFFFF;
            setter.accept(current | value << 16);
        });
    }

    protected void addDataSlot(IntSupplier gettter, IntConsumer setter) {
        this.m_38895_(new DataSlotWrapper(gettter, setter));
    }

    private class AdvancementContainerListener
    implements ContainerListener {
        private AdvancementContainerListener() {
        }

        public void m_7934_(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
            FortronMenu.this.triggerMenuAdvancement();
        }

        public void m_142153_(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        }
    }
}

