/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.api.FrequencyBlock;
import dev.su5ed.mffs.api.card.CoordLink;
import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.menu.FortronMenu;
import dev.su5ed.mffs.render.particle.ParticleColor;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.Fortron;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.ModUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class RemoteControllerItem
extends BaseItem
implements CoordLink {
    public RemoteControllerItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().m_41487_(1)).description());
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        BlockEntity be;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (!level.f_46443_ && player.m_6144_() && (be = level.m_7702_(pos = context.m_8083_())) != null && be.getCapability(ModCapabilities.FORTRON).isPresent()) {
            this.setLink(stack, pos);
            BlockState state = level.m_8055_(pos);
            player.m_5661_((Component)ModUtil.translate("info", "link", state.m_60734_().m_49954_(), pos.m_123344_()).m_130940_(ChatFormatting.AQUA), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        BlockEntity be;
        BlockPos pos;
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.f_46443_ && !player.m_6144_() && (pos = this.getLink(stack)) != null && level.m_46749_(pos) && (be = level.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)be;
            if (Fortron.hasPermission(level, pos, FieldPermission.USE_BLOCKS, player) || Fortron.hasPermission(level, pos, FieldPermission.REMOTE_CONTROL, player)) {
                double requiredEnergy = ModUtil.distance(player.m_20183_(), pos) * 10.0;
                int frequency = (Integer)be.getCapability(ModCapabilities.FORTRON).map(FrequencyBlock::getFrequency).orElseThrow();
                if (this.drawEnergy(level, player.m_20183_(), player.m_20182_().m_82520_(0.0, (double)player.m_20192_() - 0.2, 0.0), frequency, (int)requiredEnergy)) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new RemoteMenuProvider(menuProvider), (BlockPos)pos);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                player.m_5661_((Component)ModUtil.translate("info", "cannot_harness", Math.round(requiredEnergy)).m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        BlockEntity be;
        BlockPos pos = this.getLink(stack);
        if (level != null && pos != null && (be = level.m_7702_(pos)) != null && be.getCapability(ModCapabilities.FORTRON).isPresent()) {
            tooltipComponents.add((Component)ModUtil.translate("info", "link", be.m_58900_().m_60734_().m_49954_().m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    @Nullable
    public BlockPos getLink(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_("link"));
    }

    @Override
    public void setLink(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("link", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    private boolean drawEnergy(Level level, BlockPos pos, Vec3 target, int frequency, int energy) {
        int required;
        List<FortronStorage> fortronTiles = FrequencyGrid.instance().get(level, (Vec3i)pos, 50, frequency);
        fortronTiles.sort(Comparator.comparingDouble(fortron -> fortron.getOwner().m_58899_().m_203193_((Position)target)));
        int total = 0;
        ArrayList<FortronStorage> transmitters = new ArrayList<FortronStorage>();
        for (FortronStorage fortron2 : fortronTiles) {
            int receivedEnergy = fortron2.extractFortron(required = energy - total, true);
            if (receivedEnergy > 0) {
                transmitters.add(fortron2);
            }
            if ((total += receivedEnergy) < energy) continue;
            break;
        }
        if (total >= energy) {
            total = 0;
            for (FortronStorage fortron2 : transmitters) {
                required = energy - total;
                total += fortron2.extractFortron(required, false);
                BlockPos fortronPos = fortron2.getOwner().m_58899_();
                Fortron.renderClientBeam(level, target, Vec3.m_82512_((Vec3i)fortronPos), fortronPos, ParticleColor.BLUE_BEAM, 20);
            }
            return true;
        }
        return false;
    }

    private record RemoteMenuProvider(MenuProvider wrapped) implements MenuProvider
    {
        public Component m_5446_() {
            return this.wrapped.m_5446_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
            AbstractContainerMenu menu = this.wrapped.m_7208_(containerId, playerInventory, player);
            if (menu instanceof FortronMenu) {
                FortronMenu fortronMenu = (FortronMenu)menu;
                fortronMenu.setRemoteAccess(true);
            }
            return menu;
        }
    }
}

