/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import dev.su5ed.mffs.util.inventory.InventorySlotItemHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryBlockEntity
extends BaseBlockEntity {
    protected final InventorySlotItemHandler items = new InventorySlotItemHandler(this::onInventoryChanged);
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(() -> this.items);

    protected InventoryBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode) {
        return this.addSlot(name, mode, stack -> true);
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter) {
        return this.items.addSlot(name, mode, filter);
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        return this.items.addSlot(name, mode, filter, onChanged);
    }

    protected void onInventoryChanged() {
    }

    @Override
    public void provideAdditionalDrops(List<? super ItemStack> drops) {
        super.provideAdditionalDrops(drops);
        drops.addAll(this.items.getAllItems());
    }

    public boolean mergeIntoInventory(ItemStack stack) {
        if (!this.f_58857_.f_46443_ && !stack.m_41619_()) {
            ItemStack remainder = stack;
            for (Direction side : Direction.values()) {
                IItemHandler handler = Optional.ofNullable(this.f_58857_.m_7702_(this.f_58858_.m_121945_(side))).flatMap(be -> be.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).resolve()).orElse(null);
                if (handler == null) continue;
                remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            }
            if (!remainder.m_41619_()) {
                ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, remainder);
                this.f_58857_.m_7967_((Entity)item);
            }
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void saveCommonTag(CompoundTag tag) {
        super.saveCommonTag(tag);
        tag.m_128365_("items", (Tag)this.items.serializeNBT());
    }

    @Override
    protected void loadCommonTag(CompoundTag tag) {
        super.loadCommonTag(tag);
        this.items.deserializeNBT(tag.m_128469_("items"));
    }
}

