/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.api.Activatable;
import dev.su5ed.mffs.api.card.CoordLink;
import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.BiometricIdentifierLink;
import dev.su5ed.mffs.block.BaseEntityBlock;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.InventoryBlockEntity;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.Fortron;
import dev.su5ed.mffs.util.FortronStorageImpl;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.TransferMode;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FortronBlockEntity
extends InventoryBlockEntity
implements BiometricIdentifierLink,
Activatable {
    public final InventorySlot frequencySlot;
    public final FortronStorageImpl fortronStorage = new FortronStorageImpl(this, this.getBaseFortronTankCapacity() * 1000, () -> ((FortronBlockEntity)this).m_6596_());
    private final LazyOptional<FortronStorage> fortronCap = LazyOptional.of(() -> this.fortronStorage);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(this.fortronStorage::getFortronTank);
    private boolean markSendFortron = true;
    private boolean active;
    protected int animation;

    protected FortronBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.frequencySlot = this.addSlot("frequency", InventorySlot.Mode.BOTH, ModUtil::isCard, this::onFrequencySlotChanged);
    }

    public int getAnimation() {
        return this.animation;
    }

    public void setMarkSendFortron(boolean markSendFortron) {
        this.markSendFortron = markSendFortron;
    }

    public int getBaseFortronTankCapacity() {
        return 1;
    }

    protected List<ItemStack> getCards() {
        return List.of(this.frequencySlot.getItem());
    }

    protected void animate() {
        if (this.isActive()) {
            ++this.animation;
        }
    }

    protected void onFrequencySlotChanged(ItemStack stack) {
        stack.getCapability(ModCapabilities.FREQUENCY_CARD).ifPresent(card -> card.setFrequency(this.fortronStorage.getFrequency()));
    }

    @Override
    public boolean isActive() {
        return this.f_58857_.f_46443_ ? (Boolean)this.m_58900_().m_61143_(BaseEntityBlock.ACTIVE) : this.active || this.f_58857_.m_276867_(this.f_58858_);
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
        FrequencyGrid.instance().register(this.fortronStorage);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        FrequencyGrid.instance().unregister(this.fortronStorage);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        BlockState state = this.m_58900_();
        boolean active = this.isActive();
        if ((Boolean)state.m_61143_(BaseEntityBlock.ACTIVE) != active) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_(BaseEntityBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.animate();
    }

    @Override
    public void beforeBlockRemove() {
        super.beforeBlockRemove();
        if (this.markSendFortron) {
            Fortron.transferFortron(this.fortronStorage, FrequencyGrid.instance().get(this.f_58857_, (Vec3i)this.f_58858_, 100, this.fortronStorage.getFrequency()), TransferMode.DRAIN, Integer.MAX_VALUE);
        }
    }

    @Override
    protected void loadCommonTag(CompoundTag tag) {
        super.loadCommonTag(tag);
        this.fortronStorage.deserializeNBT(tag.m_128469_("fortronStorage"));
        this.active = tag.m_128471_("active");
    }

    @Override
    protected void saveCommonTag(CompoundTag tag) {
        super.saveCommonTag(tag);
        tag.m_128365_("fortronStorage", (Tag)this.fortronStorage.serializeNBT());
        tag.m_128379_("active", this.active);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.FORTRON) {
            return this.fortronCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public BiometricIdentifier getBiometricIdentifier() {
        return this.getBiometricIdentifiers().stream().findFirst().orElse(null);
    }

    @Override
    public Set<BiometricIdentifier> getBiometricIdentifiers() {
        return ((StreamEx)StreamEx.of(this.getCards()).mapPartial(stack -> {
            Item patt6060$temp = stack.m_41720_();
            if (patt6060$temp instanceof CoordLink) {
                CoordLink link = (CoordLink)patt6060$temp;
                return Optional.ofNullable(link.getLink((ItemStack)stack)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).flatMap(be -> be.getCapability(ModCapabilities.BIOMETRIC_IDENTIFIER).resolve());
            }
            return Optional.empty();
        }).append((Stream)StreamEx.of(FrequencyGrid.instance().get(this.fortronStorage.getFrequency())).mapPartial(storage -> storage.getOwner().getCapability(ModCapabilities.BIOMETRIC_IDENTIFIER).resolve()))).toSet();
    }
}

