/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.blockentity.ElectricTileEntity;
import dev.su5ed.mffs.menu.CoercionDeriverMenu;
import dev.su5ed.mffs.setup.ModModules;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.setup.ModTags;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class CoercionDeriverBlockEntity
extends ElectricTileEntity {
    private static final int DEFAULT_FE_CAPACITY = 1500000;
    public final InventorySlot batterySlot;
    public final InventorySlot fuelSlot;
    public final List<InventorySlot> upgradeSlots;
    private int processTime;
    private EnergyMode energyMode = EnergyMode.DERIVE;

    public CoercionDeriverBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseBlockEntity>)((BlockEntityType)ModObjects.COERCION_DERIVER_BLOCK_ENTITY.get()), pos, state, 1500000);
        this.batterySlot = this.addSlot("battery", InventorySlot.Mode.BOTH, stack -> stack.getCapability(ForgeCapabilities.ENERGY).isPresent());
        this.fuelSlot = this.addSlot("fuel", InventorySlot.Mode.BOTH, stack -> stack.m_204117_(ModTags.FORTRON_FUEL));
        this.upgradeSlots = this.createUpgradeSlots(3);
        this.energy.setMaxTransfer(this.getMaxTransferRate());
    }

    public EnergyMode getEnergyMode() {
        return this.energyMode;
    }

    public void setEnergyMode(EnergyMode energyMode) {
        this.energyMode = energyMode;
    }

    public int getMaxTransferRate() {
        return (int)(1500000.0f + 1500000.0f * ((float)this.getModuleCount(ModModules.SPEED) / 8.0f));
    }

    public boolean isInversed() {
        return this.energyMode == EnergyMode.INTEGRATE;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(int processTime) {
        this.processTime = processTime;
    }

    private double getEnergyConversionRatio() {
        return (Double)MFFSConfig.COMMON.energyConversionRatio.get();
    }

    @Override
    public int getBaseFortronTankCapacity() {
        return 30;
    }

    @Override
    protected void addModuleSlots(List<? super InventorySlot> list) {
        super.addModuleSlots(list);
        list.addAll(this.upgradeSlots);
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        this.energy.setMaxTransfer(this.getMaxTransferRate());
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.isActive()) {
            if (this.isInversed() && ((Boolean)MFFSConfig.COMMON.enableElectricity.get()).booleanValue()) {
                if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                    int withdrawnElectricity = (int)((double)this.fortronStorage.extractFortron(this.getProductionRate() / 20, false) / this.getEnergyConversionRatio());
                    this.energy.receiveEnergy((int)((double)withdrawnElectricity * (Double)MFFSConfig.COMMON.backConversionEnergyLoss.get()), true);
                }
                this.charge(this.batterySlot.getItem());
                this.receiveEnergy();
            } else if (this.fortronStorage.getStoredFortron() < this.fortronStorage.getFortronCapacity()) {
                this.discharge(this.batterySlot.getItem());
                int production = this.getProductionRate();
                if (this.energy.canExtract(production) || !((Boolean)MFFSConfig.COMMON.enableElectricity.get()).booleanValue() && this.hasFuel()) {
                    this.energy.extractEnergy(production, false);
                    this.fortronStorage.insertFortron(production, false);
                    if (this.processTime == 0 && this.hasFuel()) {
                        this.fuelSlot.getItem().m_41774_(1);
                        this.processTime = (Integer)MFFSConfig.COMMON.catalystBurnTime.get() * Math.max(this.getModuleCount(ModModules.SCALE) / 20, 1);
                    }
                    this.processTime = Math.max(--this.processTime, 0);
                }
            }
        }
    }

    public int getProductionRate() {
        if (this.isActive()) {
            int production = (int)((double)((float)this.getMaxTransferRate() / 20.0f) * this.getEnergyConversionRatio());
            return this.processTime > 0 ? (int)((double)production * (Double)MFFSConfig.COMMON.catalystMultiplier.get()) : production;
        }
        return 0;
    }

    public boolean hasFuel() {
        return !this.fuelSlot.isEmpty();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new CoercionDeriverMenu(containerId, this.f_58858_, player, inventory);
    }

    @Override
    protected void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        tag.m_128405_("processTime", this.processTime);
        tag.m_128359_("energyMode", this.energyMode.name());
    }

    @Override
    protected void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.processTime = tag.m_128451_("processTime");
        this.energyMode = EnergyMode.valueOf(tag.m_128461_("energyMode"));
    }

    @Override
    public Set<Direction> getEnergyInputSides() {
        return EnumSet.allOf(Direction.class);
    }

    @Override
    public Set<Direction> getEnergyOutputSides() {
        return EnumSet.allOf(Direction.class);
    }

    public static enum EnergyMode {
        DERIVE,
        INTEGRATE;

        private static final EnergyMode[] VALUES;

        public EnergyMode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public MutableComponent translate() {
            return ModUtil.translate("info", "coercion_deriver.mode." + this.name().toLowerCase(Locale.ROOT), new Object[0]);
        }

        static {
            VALUES = EnergyMode.values();
        }
    }
}

