/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.platform.forge;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.recipe.EmiBrewingRecipe;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.runtime.EmiLog;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.text.WordUtils;
import org.objectweb.asm.Type;

public class EmiAgnosForge
extends EmiAgnos {
    @Override
    protected boolean isForgeAgnos() {
        return true;
    }

    @Override
    protected String getModNameAgnos(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = ModList.get().getModContainerById(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        container = ModList.get().getModContainerById(namespace.replace('_', '-'));
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        return WordUtils.capitalizeFully((String)namespace.replace('_', ' '));
    }

    @Override
    protected Path getConfigDirectoryAgnos() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    protected boolean isDevelopmentEnvironmentAgnos() {
        return !FMLLoader.isProduction();
    }

    @Override
    protected boolean isModLoadedAgnos(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    protected List<String> getAllModNamesAgnos() {
        return ModList.get().getMods().stream().map(m -> m.getDisplayName()).toList();
    }

    @Override
    protected List<EmiPluginContainer> getPluginsAgnos() {
        ArrayList containers = Lists.newArrayList();
        Type entrypointType = Type.getType(EmiEntrypoint.class);
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annot : data.getAnnotations()) {
                try {
                    if (!entrypointType.equals((Object)annot.annotationType())) continue;
                    Class<?> clazz = Class.forName(annot.memberName());
                    if (EmiPlugin.class.isAssignableFrom(clazz)) {
                        Class<EmiPlugin> pluginClass = clazz.asSubclass(EmiPlugin.class);
                        EmiPlugin plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        String id = ((IModInfo)((IModFileInfo)data.getIModInfoData().get(0)).getMods().get(0)).getModId();
                        containers.add(new EmiPluginContainer(plugin, id));
                        continue;
                    }
                    EmiLog.error("EmiEntrypoint " + annot.memberName() + " does not implement EmiPlugin");
                }
                catch (Throwable t) {
                    EmiLog.error("Exception constructing entrypoint:");
                    t.printStackTrace();
                }
            }
        }
        return containers;
    }

    @Override
    protected void addBrewingRecipesAgnos(EmiRegistry registry) {
        for (Ingredient ingredient : PotionBrewing.f_43496_) {
            for (ItemStack stack : ingredient.m_43908_()) {
                String pid = EmiUtil.subId(stack.m_41720_());
                for (PotionBrewing.Mix recipe : PotionBrewing.f_43494_) {
                    try {
                        if (recipe.f_43533_.m_43908_().length <= 0) continue;
                        ResourceLocation id = new ResourceLocation("emi", "/brewing/" + pid + "/" + EmiUtil.subId(recipe.f_43533_.m_43908_()[0].m_41720_()) + "/" + EmiUtil.subId(EmiPort.getPotionRegistry().m_7981_((Object)((Potion)recipe.f_43532_.get()))) + "/" + EmiUtil.subId(EmiPort.getPotionRegistry().m_7981_((Object)((Potion)recipe.f_43534_.get()))));
                        registry.addRecipe(new EmiBrewingRecipe(EmiStack.of(EmiPort.setPotion(stack.m_41777_(), (Potion)recipe.f_43532_.get())), EmiIngredient.of(recipe.f_43533_), EmiStack.of(EmiPort.setPotion(stack.m_41777_(), (Potion)recipe.f_43534_.get())), id));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (PotionBrewing.Mix recipe : PotionBrewing.f_43495_) {
            try {
                if (recipe.f_43533_.m_43908_().length <= 0) continue;
                String gid = EmiUtil.subId(recipe.f_43533_.m_43908_()[0].m_41720_());
                String iid = EmiUtil.subId((Item)recipe.f_43532_.get());
                String oid = EmiUtil.subId((Item)recipe.f_43534_.get());
                Consumer<Holder> potionRecipeGen = entry -> {
                    Potion potion = (Potion)entry.m_203334_();
                    if (potion == Potions.f_43598_) {
                        return;
                    }
                    if (PotionBrewing.m_43511_((Potion)potion)) {
                        ResourceLocation id = new ResourceLocation("emi", "brewing/item/" + EmiUtil.subId(((ResourceKey)entry.m_203543_().get()).m_135782_()) + "/" + gid + "/" + iid + "/" + oid);
                        registry.addRecipe(new EmiBrewingRecipe(EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)recipe.f_43532_.get()), potion)), EmiIngredient.of(recipe.f_43533_), EmiStack.of(EmiPort.setPotion(new ItemStack((ItemLike)recipe.f_43534_.get()), potion)), id));
                    }
                };
                if (recipe.f_43532_.get() instanceof PotionItem) {
                    EmiPort.getPotionRegistry().m_203611_().forEach(potionRecipeGen);
                    continue;
                }
                potionRecipeGen.accept(EmiPort.getPotionRegistry().m_263177_((Object)Potions.f_43602_));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (IBrewingRecipe ibr : BrewingRecipeRegistry.getRecipes()) {
            try {
                if (!(ibr instanceof BrewingRecipe)) continue;
                BrewingRecipe recipe = (BrewingRecipe)ibr;
                for (ItemStack is : recipe.getInput().m_43908_()) {
                    EmiStack input = EmiStack.of(is);
                    EmiIngredient ingredient = EmiIngredient.of(recipe.getIngredient());
                    EmiStack output = EmiStack.of(recipe.getOutput(is, recipe.getIngredient().m_43908_()[0]));
                    ResourceLocation id = new ResourceLocation("emi", "brewing/forge/" + EmiUtil.subId(input.getId()) + "/" + EmiUtil.subId(ingredient.getEmiStacks().get(0).getId()) + "/" + EmiUtil.subId(output.getId()));
                    registry.addRecipe(new EmiBrewingRecipe(input, ingredient, output, id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected List<String> getAllModAuthorsAgnos() {
        return ModList.get().getMods().stream().flatMap(m -> {
            Optional opt = m.getConfig().getConfigElement(new String[]{"authors"});
            if (opt.isPresent()) {
                List list;
                Object obj = opt.get();
                if (obj instanceof String) {
                    String authors = (String)obj;
                    return Lists.newArrayList((Object[])authors.split("\\,")).stream().map(s -> s.trim());
                }
                if (obj instanceof List && (list = (List)obj).size() > 0 && list.get(0) instanceof String) {
                    List authors = list;
                    return authors.stream();
                }
            }
            return Stream.empty();
        }).distinct().toList();
    }

    @Override
    protected List<ClientTooltipComponent> getItemTooltipAgnos(ItemStack stack) {
        Minecraft client = Minecraft.m_91087_();
        return ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, (List)Screen.m_280152_((Minecraft)client, (ItemStack)stack), (Optional)stack.m_150921_(), (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)client.f_91062_);
    }

    @Override
    protected Component getFluidNameAgnos(Fluid fluid, CompoundTag nbt) {
        return new FluidStack(fluid, 1000, nbt).getDisplayName();
    }

    @Override
    protected List<Component> getFluidTooltipAgnos(Fluid fluid, CompoundTag nbt) {
        return List.of(EmiAgnosForge.getFluidName(fluid, nbt));
    }

    @Override
    protected boolean isFloatyFluidAgnos(FluidEmiStack stack) {
        FluidStack fs = new FluidStack(stack.getKeyOfType(Fluid.class), 1000, stack.getNbt());
        return fs.getFluid().getFluidType().isLighterThanAir();
    }

    @Override
    protected void renderFluidAgnos(FluidEmiStack stack, PoseStack matrices, int x, int y, float delta, int xOff, int yOff, int width, int height) {
        FluidStack fs = new FluidStack(stack.getKeyOfType(Fluid.class), 1000, stack.getNbt());
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fs.getFluid());
        ResourceLocation texture = ext.getStillTexture(fs);
        int color = ext.getTintColor(fs);
        Minecraft client = Minecraft.m_91087_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)client.m_91258_(InventoryMenu.f_39692_).apply(texture);
        EmiRenderHelper.drawTintedSprite(matrices, sprite, color, x, y, xOff, yOff, width, height);
    }

    @Override
    protected EmiStack createFluidStackAgnos(Object object) {
        if (object instanceof FluidStack) {
            FluidStack f = (FluidStack)object;
            return EmiStack.of(f.getFluid(), f.getTag(), (long)f.getAmount());
        }
        return EmiStack.EMPTY;
    }

    @Override
    protected boolean canBatchAgnos(ItemStack stack) {
        Minecraft client = Minecraft.m_91087_();
        ItemRenderer ir = client.m_91291_();
        BakedModel model = ir.m_174264_(stack, (Level)client.f_91073_, null, 0);
        return model != null && model.getClass() == SimpleBakedModel.class;
    }

    @Override
    protected Map<Item, Integer> getFuelMapAgnos() {
        Object2IntOpenHashMap fuelMap = new Object2IntOpenHashMap();
        for (Item item : EmiPort.getItemRegistry()) {
            int time = ForgeHooks.getBurnTime((ItemStack)item.m_7968_(), null);
            if (time <= 0) continue;
            fuelMap.put((Object)item, time);
        }
        return fuelMap;
    }

    static {
        EmiAgnos.delegate = new EmiAgnosForge();
    }
}

