/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.registry.EmiTags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public interface EmiIngredient
extends EmiRenderable {
    public static final int RENDER_ICON = 1;
    public static final int RENDER_AMOUNT = 2;
    public static final int RENDER_INGREDIENT = 4;
    public static final int RENDER_REMAINDER = 8;

    public List<EmiStack> getEmiStacks();

    default public boolean isEmpty() {
        for (EmiStack stack : this.getEmiStacks()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public EmiIngredient copy();

    public long getAmount();

    public EmiIngredient setAmount(long var1);

    public float getChance();

    public EmiIngredient setChance(float var1);

    @Override
    default public void render(GuiGraphics draw, int x, int y, float delta) {
        this.render(draw, x, y, delta, -1);
    }

    public void render(GuiGraphics var1, int var2, int var3, float var4, int var5);

    public List<ClientTooltipComponent> getTooltip();

    public static boolean areEqual(EmiIngredient a, EmiIngredient b) {
        List<EmiStack> as = a.getEmiStacks();
        List<EmiStack> bs = b.getEmiStacks();
        if (as.size() != bs.size()) {
            return false;
        }
        for (int i = 0; i < as.size(); ++i) {
            if (as.get(i).isEqual(bs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> EmiIngredient of(TagKey<T> key) {
        return EmiIngredient.of(key, 1L);
    }

    public static <T> EmiIngredient of(TagKey<T> key, long amount) {
        return EmiIngredient.of(EmiTags.getRawValues(key), amount);
    }

    public static EmiIngredient of(Ingredient ingredient) {
        if (ingredient == null) {
            return EmiStack.EMPTY;
        }
        ItemStack[] stacks = ingredient.m_43908_();
        int amount = 1;
        if (stacks.length != 0) {
            amount = stacks[0].m_41613_();
            for (int i = 1; i < stacks.length; ++i) {
                if (stacks[i].m_41613_() == amount) continue;
                amount = 1;
                break;
            }
        }
        return EmiIngredient.of(ingredient, (long)amount);
    }

    public static EmiIngredient of(Ingredient ingredient, long amount) {
        if (ingredient == null) {
            return EmiStack.EMPTY;
        }
        return EmiTags.getIngredient(Item.class, Arrays.stream(ingredient.m_43908_()).map(EmiStack::of).toList(), amount);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list) {
        return EmiIngredient.of(list, 1L);
    }

    public static EmiIngredient of(List<? extends EmiIngredient> list, long amount) {
        if (list.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        long internalAmount = list.get(0).getAmount();
        for (EmiIngredient emiIngredient : list) {
            if (emiIngredient.getAmount() == internalAmount) continue;
            internalAmount = 1L;
        }
        if (internalAmount > 1L) {
            amount = internalAmount;
            list = list.stream().map(st -> st.copy().setAmount(1L)).toList();
        }
        Class<?> tagType = null;
        for (EmiIngredient emiIngredient : list) {
            for (EmiStack s : emiIngredient.getEmiStacks()) {
                if (s.isEmpty()) continue;
                if (tagType == null) {
                    tagType = EmiTags.ADAPTERS_BY_CLASS.getKey(s.getKey().getClass());
                }
                if (tagType != null && tagType.isAssignableFrom(s.getKey().getClass())) continue;
                return new ListEmiIngredient(list, amount);
            }
        }
        return EmiTags.getIngredient(tagType, list.stream().flatMap(i -> i.getEmiStacks().stream()).toList(), amount);
    }
}

