/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.enchdesc.ConfigSchema;
import net.darkhax.enchdesc.DescriptionManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.StringUtils;

public class EnchDescCommon {
    private final ConfigSchema config;
    private final DescriptionManager descriptions;

    public EnchDescCommon(Path configPath) {
        this.config = ConfigSchema.load(configPath.resolve("enchdesc.json").toFile());
        this.descriptions = new DescriptionManager(this.config);
        Services.EVENTS.addItemTooltipListener(this::onItemTooltip);
    }

    private void onItemTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Set enchantments;
        if (this.config.enableMod && !stack.m_41619_() && stack.m_41782_() && (!this.config.onlyDisplayOnBooks && stack.m_41793_() || stack.m_41720_() instanceof EnchantedBookItem) && (!this.config.onlyDisplayInEnchantingTable || Minecraft.m_91087_().f_91080_ instanceof EnchantmentScreen) && !(enchantments = EnchantmentHelper.m_44831_((ItemStack)stack).keySet()).isEmpty()) {
            if (!this.config.requireKeybindPress || Screen.m_96638_()) {
                block0: for (Enchantment enchantment : enchantments) {
                    for (Component line : tooltip) {
                        TranslatableContents translatable;
                        ComponentContents componentContents = line.m_214077_();
                        if (!(componentContents instanceof TranslatableContents) || !(translatable = (TranslatableContents)componentContents).m_237508_().equals(enchantment.m_44704_())) continue;
                        MutableComponent descriptionText = this.descriptions.get(enchantment);
                        if (this.config.indentSize > 0) {
                            descriptionText = Component.m_237113_((String)StringUtils.repeat((char)' ', (int)this.config.indentSize)).m_7220_((Component)descriptionText);
                        }
                        tooltip.add(tooltip.indexOf(line) + 1, (Component)descriptionText);
                        continue block0;
                    }
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"enchdesc.activate.message").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

