/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.config.common;

import net.minecraftforge.common.ForgeConfigSpec;

public class EnergyConfig {
    public final ForgeConfigSpec.ConfigValue<Integer> ALLOY_SMELTER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> ALLOY_SMELTER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> ALLOY_SMELTER_VANILLA_ITEM_ENERGY;
    public final ForgeConfigSpec.ConfigValue<Integer> CRAFTER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> CRAFTER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> CRAFTING_RECIPE_COST;
    public final ForgeConfigSpec.ConfigValue<Integer> IMPULSE_HOPPER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> IMPULSE_HOPPER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> POWERED_SPAWNER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> POWERED_SPAWNER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> SAG_MILL_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> SAG_MILL_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> SLICER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> SLICER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> SOUL_BINDER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> SOUL_BINDER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> STIRLING_GENERATOR_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Double> STIRLING_GENERATOR_BURN_SPEED;
    public final ForgeConfigSpec.ConfigValue<Integer> STIRLING_GENERATOR_FUEL_EFFICIENCY_BASE;
    public final ForgeConfigSpec.ConfigValue<Integer> STIRLING_GENERATOR_FUEL_EFFICIENCY_STEP;
    public final ForgeConfigSpec.ConfigValue<Integer> STIRLING_GENERATOR_PRODUCTION;
    public final ForgeConfigSpec.ConfigValue<Integer> PAINTING_MACHINE_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> PAINTING_MACHINE_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> PAINTING_MACHINE_ENERGY_COST;
    public final ForgeConfigSpec.ConfigValue<Integer> ENERGETIC_SOLAR_PANEL_MAX_PRODUCTION;
    public final ForgeConfigSpec.ConfigValue<Integer> PULSATING_SOLAR_PANEL_MAX_PRODUCTION;
    public final ForgeConfigSpec.ConfigValue<Integer> VIBRANT_SOLAR_PANEL_MAX_PRODUCTION;
    public final ForgeConfigSpec.ConfigValue<Integer> BASIC_CAPACITOR_BANK_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> ADVANCED_CAPACITOR_BANK_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> VIBRANT_CAPACITOR_BANK_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> WIRED_CHARGER_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> WIRED_CHARGER_USAGE;
    public final ForgeConfigSpec.ConfigValue<Integer> SOUL_ENGINE_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> SOUL_ENGINE_BURN_SPEED;
    public final ForgeConfigSpec.ConfigValue<Double> SOUL_ENGINE_GENERATION;
    public final ForgeConfigSpec.ConfigValue<Integer> DRAIN_CAPACITY;
    public final ForgeConfigSpec.ConfigValue<Integer> DRAIN_USAGE;

    public EnergyConfig(ForgeConfigSpec.Builder builder) {
        builder.push("energy");
        builder.push("alloySmelter");
        this.ALLOY_SMELTER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.ALLOY_SMELTER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 20, 1, Integer.MAX_VALUE);
        this.ALLOY_SMELTER_VANILLA_ITEM_ENERGY = builder.comment("The amount of energy to consume per vanilla smelting item in uI.").defineInRange("vanillaItemEnergy", 1500, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("crafter");
        this.CRAFTER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.CRAFTER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 80, 1, Integer.MAX_VALUE);
        this.CRAFTING_RECIPE_COST = builder.comment("The energy cost in uI for a crafting recipe.").defineInRange("usage", 3200, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("impulseHopper");
        this.IMPULSE_HOPPER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.IMPULSE_HOPPER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 16, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("poweredSpawner");
        this.POWERED_SPAWNER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 100000, 1, Integer.MAX_VALUE);
        this.POWERED_SPAWNER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 20, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("sagMill");
        this.SAG_MILL_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.SAG_MILL_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 20, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("slicer");
        this.SLICER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 100000, 1, Integer.MAX_VALUE);
        this.SLICER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 30, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("soulBinder");
        this.SOUL_BINDER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 128000, 1, Integer.MAX_VALUE);
        this.SOUL_BINDER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 60, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("stirlingGenerator");
        this.STIRLING_GENERATOR_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.STIRLING_GENERATOR_BURN_SPEED = builder.comment("The base number of 'burn ticks' performed per machine tick.").defineInRange("burnSpeed", 0.375, 0.001, Double.MAX_VALUE);
        this.STIRLING_GENERATOR_FUEL_EFFICIENCY_BASE = builder.comment("The base percentage efficiency, used to determine burn times.").defineInRange("fuelEfficiencyBase", 80, 1, 200);
        this.STIRLING_GENERATOR_FUEL_EFFICIENCY_STEP = builder.comment("The efficiency increase per capacitor level.").defineInRange("fuelEfficiencyStep", 20, 1, 200);
        this.STIRLING_GENERATOR_PRODUCTION = builder.comment("The base amount of energy produced in uI/t.").defineInRange("generation", 40, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("paintingMachine");
        this.PAINTING_MACHINE_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.PAINTING_MACHINE_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 30, 1, Integer.MAX_VALUE);
        this.PAINTING_MACHINE_ENERGY_COST = builder.comment("The energy required for each painting operation").defineInRange("energyCost", 2400, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("photovoltaicCellRates");
        builder.comment("Production rate at midday without rain or thunder");
        this.ENERGETIC_SOLAR_PANEL_MAX_PRODUCTION = builder.defineInRange("energetic", 4, 1, Integer.MAX_VALUE);
        this.PULSATING_SOLAR_PANEL_MAX_PRODUCTION = builder.defineInRange("pulsating", 16, 1, Integer.MAX_VALUE);
        this.VIBRANT_SOLAR_PANEL_MAX_PRODUCTION = builder.defineInRange("vibrant", 64, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("capacitor_bank_capacity");
        builder.comment("Capacity for capacitor banks");
        this.BASIC_CAPACITOR_BANK_CAPACITY = builder.defineInRange("basic", 500000, 1, Integer.MAX_VALUE);
        this.ADVANCED_CAPACITOR_BANK_CAPACITY = builder.defineInRange("advanced", 2000000, 1, Integer.MAX_VALUE);
        this.VIBRANT_CAPACITOR_BANK_CAPACITY = builder.defineInRange("vibrant", 4000000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("wiredCharger");
        this.WIRED_CHARGER_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 128000, 1, Integer.MAX_VALUE);
        this.WIRED_CHARGER_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 64, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("soul_engine");
        this.SOUL_ENGINE_CAPACITY = builder.defineInRange("capacity", 100000, 1, Integer.MAX_VALUE);
        this.SOUL_ENGINE_BURN_SPEED = builder.comment("The base burn-rate the soul engine.").defineInRange("burnSpeed", 1, 1, Integer.MAX_VALUE);
        this.SOUL_ENGINE_GENERATION = builder.comment("Percentage increase in uI produced.").defineInRange("generation", 1.0, 0.001, Double.MAX_VALUE);
        builder.pop();
        builder.push("drain");
        this.DRAIN_CAPACITY = builder.comment("The base energy capacity in uI.").defineInRange("capacity", 64000, 1, Integer.MAX_VALUE);
        this.DRAIN_USAGE = builder.comment("The base energy consumption in uI/t.").defineInRange("usage", 10, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }
}

