/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.ResourceLocationNetworkDataSlot;
import com.enderio.core.common.network.slot.StringNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.init.MachineBlockEntities;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.TravelAnchorMenu;
import com.enderio.machines.common.travel.AnchorTravelTarget;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TravelAnchorBlockEntity
extends MachineBlockEntity {
    public static final SingleSlotAccess GHOST = new SingleSlotAccess();
    private final StringNetworkDataSlot nameDataSlot = new StringNetworkDataSlot(this::getName, name -> this.getOrCreateTravelTarget().setName((String)name));
    private final BooleanNetworkDataSlot visibilityDataSlot = new BooleanNetworkDataSlot(this::getVisibility, vis -> this.getOrCreateTravelTarget().setVisibility((boolean)vis));
    private final ResourceLocationNetworkDataSlot iconDataSlot = new ResourceLocationNetworkDataSlot(() -> ForgeRegistries.ITEMS.getKey((Object)this.getIcon()), loc -> this.getOrCreateTravelTarget().setIcon((Item)ForgeRegistries.ITEMS.getValue(loc)));

    public TravelAnchorBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this((BlockEntityType)MachineBlockEntities.TRAVEL_ANCHOR.get(), pWorldPosition, pBlockState);
    }

    public TravelAnchorBlockEntity(BlockEntityType<?> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super(type, pWorldPosition, pBlockState);
        this.addDataSlot(this.nameDataSlot);
        this.addDataSlot(this.visibilityDataSlot);
        this.addDataSlot(this.iconDataSlot);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new TravelAnchorMenu(this, inventory, containerId);
    }

    @Override
    @Nullable
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().setStackLimit(1).ghostSlot().slotAccess(GHOST).build();
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        ItemStack stack = GHOST.getItemStack(this.getInventory());
        this.setIcon(stack.m_41720_());
    }

    @Nullable
    public String getName() {
        return this.getOrCreateTravelTarget().getName();
    }

    public void setName(String name) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.nameDataSlot, name);
        } else {
            this.getOrCreateTravelTarget().setName(name);
        }
    }

    public Item getIcon() {
        return this.getOrCreateTravelTarget().getIcon();
    }

    public void setIcon(Item icon) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.iconDataSlot, ForgeRegistries.ITEMS.getKey((Object)icon));
        } else {
            this.getOrCreateTravelTarget().setIcon(icon);
        }
    }

    public boolean getVisibility() {
        return this.getOrCreateTravelTarget().getVisibility();
    }

    public void setVisibility(boolean visible) {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.clientUpdateSlot(this.visibilityDataSlot, visible);
        } else {
            this.getOrCreateTravelTarget().setVisibility(visible);
        }
    }

    private AnchorTravelTarget getOrCreateTravelTarget() {
        ITravelTarget iTravelTarget;
        Optional<ITravelTarget> travelTarget = this.getTravelData().getTravelTarget(this.f_58858_);
        if (travelTarget.isPresent() && (iTravelTarget = travelTarget.get()) instanceof AnchorTravelTarget) {
            AnchorTravelTarget anchorTravelTarget = (AnchorTravelTarget)iTravelTarget;
            return anchorTravelTarget;
        }
        AnchorTravelTarget anchorTravelTarget = new AnchorTravelTarget(this.f_58858_, "", Items.f_41852_, true);
        this.getTravelData().addTravelTarget(this.f_58857_, anchorTravelTarget);
        return anchorTravelTarget;
    }

    private TravelSavedData getTravelData() {
        return TravelSavedData.getTravelData(this.f_58857_);
    }
}

