/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.FixedScalable;
import com.enderio.api.capacitor.ICapacitorData;
import com.enderio.api.capacitor.LinearScalable;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.capacitor.SteppedScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.FloatNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.StirlingGeneratorMenu;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class StirlingGeneratorBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_CAPACITY);
    public static final SteppedScalable FUEL_EFFICIENCY = new SteppedScalable(CapacitorModifier.FUEL_EFFICIENCY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_FUEL_EFFICIENCY_BASE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_FUEL_EFFICIENCY_STEP);
    public static final LinearScalable GENERATION_SPEED = new LinearScalable(CapacitorModifier.BURNING_ENERGY_GENERATION, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_PRODUCTION);
    public static final SingleSlotAccess FUEL = new SingleSlotAccess();
    private int burnTime;
    private int burnDuration;
    @UseOnly(value=LogicalSide.CLIENT)
    private float clientBurnProgress;

    public StirlingGeneratorBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Output, CAPACITY, FixedScalable.ZERO, type, worldPosition, blockState);
        this.addDataSlot(new FloatNetworkDataSlot(this::getBurnProgress, p -> {
            this.clientBurnProgress = p.floatValue();
        }));
    }

    public int getGenerationRate() {
        return GENERATION_SPEED.scaleI((NonNullSupplier<ICapacitorData>)((NonNullSupplier)this::getCapacitorData)).get();
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().inputSlot((slot, stack) -> ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0 && stack.getCraftingRemainingItem().m_41619_()).slotAccess(FUEL).capacitor().build();
    }

    @Override
    public void serverTick() {
        int burningTime;
        ItemStack fuel;
        if (this.isGenerating()) {
            --this.burnTime;
            if (!this.requiresCapacitor() || this.isCapacitorInstalled()) {
                this.energyStorage.addEnergy(this.getGenerationRate());
            }
        }
        if (this.canAct() && !this.isGenerating() && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored() && !(fuel = FUEL.getItemStack(this)).m_41619_() && (burningTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_)) > 0) {
            float burnSpeed = ((Double)MachinesConfig.COMMON.ENERGY.STIRLING_GENERATOR_BURN_SPEED.get()).floatValue();
            float efficiency = FUEL_EFFICIENCY.scaleF((NonNullSupplier<ICapacitorData>)((NonNullSupplier)this::getCapacitorData)).get().floatValue() / 100.0f;
            this.burnDuration = this.burnTime = (int)Math.floor((float)burningTime * burnSpeed * efficiency);
            fuel.m_41774_(1);
        }
        super.serverTick();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.isGenerating();
    }

    public boolean isGenerating() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.burnTime > 0;
    }

    public float getBurnProgress() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return this.clientBurnProgress;
        }
        if (this.burnDuration != 0) {
            return (float)this.burnTime / (float)this.burnDuration;
        }
        return 0.0f;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new StirlingGeneratorMenu(this, pInventory, pContainerId);
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        if (FUEL.isSlot(slot)) {
            this.updateMachineState(MachineState.EMPTY_INPUT, FUEL.getItemStack(this.getInventoryNN()).m_41619_());
        }
    }

    @Override
    protected MachineEnergyStorage createEnergyStorage(EnergyIOMode energyIOMode, Supplier<Integer> capacity, Supplier<Integer> usageRate) {
        return new MachineEnergyStorage(this.getIOConfig(), energyIOMode, capacity, usageRate){

            @Override
            protected void onContentsChanged() {
                StirlingGeneratorBlockEntity.this.m_6596_();
                StirlingGeneratorBlockEntity.this.updateMachineState(MachineState.FULL_POWER, StirlingGeneratorBlockEntity.this.getEnergyStorage().getEnergyStored() >= StirlingGeneratorBlockEntity.this.getEnergyStorage().getMaxEnergyStored() && StirlingGeneratorBlockEntity.this.isCapacitorInstalled());
            }
        };
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.updateMachineState(MachineState.NO_POWER, false);
        this.updateMachineState(MachineState.FULL_POWER, this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored() && this.isCapacitorInstalled());
        this.updateMachineState(MachineState.EMPTY_INPUT, FUEL.getItemStack(this.getInventoryNN()).m_41619_());
    }

    @Override
    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateMachineState(MachineState.NO_POWER, false);
        this.updateMachineState(MachineState.FULL_POWER, this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored() && this.isCapacitorInstalled());
        this.updateMachineState(MachineState.EMPTY_INPUT, FUEL.getItemStack(this.getInventoryNN()).m_41619_());
    }
}

