/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.task.PoweredCraftingMachineTask;
import com.enderio.machines.common.blockentity.task.host.CraftingMachineTaskHost;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.SoulBinderMenu;
import com.enderio.machines.common.recipe.RecipeCaches;
import com.enderio.machines.common.recipe.SoulBindingRecipe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SoulBinderBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_BINDER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_BINDER_USAGE);
    public static final SingleSlotAccess INPUT_SOUL = new SingleSlotAccess();
    public static final SingleSlotAccess INPUT_OTHER = new SingleSlotAccess();
    public static final MultiSlotAccess OUTPUT = new MultiSlotAccess();
    private static final TankAccess TANK = new TankAccess();
    @UseOnly(value=LogicalSide.CLIENT)
    @Nullable
    private SoulBindingRecipe clientRecipe;
    @UseOnly(value=LogicalSide.CLIENT)
    private final SoulBindingRecipe.Container fakeContainer = new SoulBindingRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), () -> Integer.MAX_VALUE);
    private final CraftingMachineTaskHost<SoulBindingRecipe, SoulBindingRecipe.Container> craftingTaskHost;

    public SoulBinderBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> TANK.getFluidAmount(this), i -> TANK.setFluid(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.get(), i.intValue()))));
        this.craftingTaskHost = new CraftingMachineTaskHost<SoulBindingRecipe, SoulBindingRecipe.Container>(this, this::hasEnergy, (RecipeType)MachineRecipes.SOUL_BINDING.type().get(), new SoulBindingRecipe.Container((IItemHandlerModifiable)this.getInventoryNN(), () -> TANK.getFluidAmount(this)), this::createTask);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SoulBinderMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.craftingTaskHost.tick();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.craftingTaskHost.onLevelReady();
    }

    @Override
    public MachineInventoryLayout getInventoryLayout() {
        return MachineInventoryLayout.builder().setStackLimit(1).inputSlot((slot, stack) -> stack.m_150930_((Item)EIOItems.FILLED_SOUL_VIAL.get())).slotAccess(INPUT_SOUL).inputSlot(this::isValidInput).slotAccess(INPUT_OTHER).setStackLimit(64).outputSlot(2).slotAccess(OUTPUT).capacitor().build();
    }

    @Override
    @Nullable
    public MachineTankLayout getTankLayout() {
        return MachineTankLayout.builder().tank(TANK, 10000, true, false, f -> f.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE)).build();
    }

    private boolean isValidInput(int index, ItemStack stack) {
        return RecipeCaches.SOUL_BINDING.hasRecipe(List.of(stack));
    }

    @Override
    protected void onInventoryContentsChanged(int slot) {
        super.onInventoryContentsChanged(slot);
        this.craftingTaskHost.newTaskAvailable();
        this.clientRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.SOUL_BINDING.type().get(), (Container)this.fakeContainer, this.f_58857_).orElse(null);
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public int getClientExp() {
        if (this.f_58857_ != null && this.clientRecipe == null && this.hasValidRecipe()) {
            this.clientRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)MachineRecipes.SOUL_BINDING.type().get(), (Container)this.fakeContainer, this.f_58857_).orElse(null);
        }
        return this.clientRecipe != null ? this.clientRecipe.getExpCost() : 0;
    }

    private boolean hasValidRecipe() {
        return RecipeCaches.SOUL_BINDING.hasRecipe(List.of(INPUT_SOUL.getItemStack(this.getInventoryNN()), INPUT_OTHER.getItemStack(this.getInventoryNN())));
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), layout){

            @Override
            protected void onContentsChanged(int slot) {
                SoulBinderBlockEntity.this.craftingTaskHost.newTaskAvailable();
                SoulBinderBlockEntity.this.updateMachineState(MachineState.EMPTY_TANK, TANK.getFluidAmount(this) <= 0);
                SoulBinderBlockEntity.this.m_6596_();
            }

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (TANK.isFluidValid(this, resource)) {
                    Fluid currentFluid = TANK.getFluid(this).getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }

    public float getCraftingProgress() {
        return this.craftingTaskHost.getProgress();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy() && this.craftingTaskHost.hasTask();
    }

    protected PoweredCraftingMachineTask<SoulBindingRecipe, SoulBindingRecipe.Container> createTask(Level level, SoulBindingRecipe.Container container, @Nullable SoulBindingRecipe recipe) {
        return new PoweredCraftingMachineTask<SoulBindingRecipe, SoulBindingRecipe.Container>(level, this.getInventoryNN(), this.getEnergyStorage(), container, OUTPUT, recipe){

            @Override
            protected void consumeInputs(SoulBindingRecipe recipe) {
                INPUT_SOUL.getItemStack(this.getInventory()).m_41774_(1);
                INPUT_OTHER.getItemStack(this.getInventory()).m_41774_(1);
                MachineFluidHandler handler = SoulBinderBlockEntity.this.getFluidHandlerNN();
                int leftover = ExperienceUtil.getLevelFromFluidWithLeftover(TANK.getFluidAmount(handler), 0, recipe.getExpCost()).experience();
                TANK.drain(handler, TANK.getFluidAmount(handler) - leftover * ExperienceUtil.EXP_TO_FLUID, IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.craftingTaskHost.save(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.craftingTaskHost.load(pTag);
    }
}

