/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget.ioconfig;

import com.enderio.EnderIO;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.machines.client.gui.widget.ioconfig.IOConfigWidget;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.base.MultiConfigurable;
import com.enderio.machines.common.menu.MachineMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IOConfigButton<U extends EIOScreen<?>, T extends AbstractWidget>
extends AbstractWidget {
    private static final int RENDERER_HEIGHT = 80;
    public static final ResourceLocation IOCONFIG = EnderIO.loc("textures/gui/icons/io_config.png");
    private static final Inset INSET_ZERO = new Inset(0, 0, 0, 0);
    private final IOConfigWidget<U> configRenderer;
    private final ImageButton neighbourButton;
    private final Supplier<Boolean> playerInvVisible;
    private final Function<Boolean, Boolean> setPlayerInvVisible;
    private final U addedOn;

    public IOConfigButton(U addedOn, int x, int y, int width, int height, MachineMenu<?> menu, Function<AbstractWidget, T> addRenderableWidget, Font font) {
        this(addedOn, x, y, width, height, menu, addRenderableWidget, font, INSET_ZERO);
    }

    public IOConfigButton(U addedOn, int x, int y, int width, int height, MachineMenu<?> menu, Function<AbstractWidget, T> addRenderableWidget, Font font, Inset inset) {
        super(x, y, width, height, EIOLang.IOCONFIG);
        List<BlockPos> list;
        this.addedOn = addedOn;
        this.playerInvVisible = menu::getPlayerInvVisible;
        this.setPlayerInvVisible = menu::setPlayerInvVisible;
        this.m_257544_(Tooltip.m_257550_((Component)EIOLang.IOCONFIG.m_6881_().m_130940_(ChatFormatting.WHITE)));
        boolean show = this.playerInvVisible.get() == false;
        Object t = menu.getBlockEntity();
        if (t instanceof MultiConfigurable) {
            MultiConfigurable multiConfigurable = (MultiConfigurable)t;
            list = multiConfigurable.getConfigurables();
        } else {
            list = List.of(((MachineBlockEntity)menu.getBlockEntity()).m_58899_());
        }
        List<BlockPos> configurables = list;
        this.configRenderer = new IOConfigWidget<U>(addedOn, addedOn.getGuiLeft() + 5 + inset.left, addedOn.getGuiTop() + addedOn.getYSize() - 80 - 5 + inset.top, addedOn.getXSize() - 10 - inset.left - inset.right, 80 - inset.top - inset.bottom, configurables, font);
        this.configRenderer.f_93624_ = show;
        addRenderableWidget.apply(this.configRenderer);
        this.neighbourButton = new ImageButton(addedOn.getGuiLeft() + addedOn.getXSize() - 5 - 16, addedOn.getGuiTop() + addedOn.getYSize() - 5 - 16, 16, 16, 16, 0, 0, IOCONFIG, 48, 32, b -> this.configRenderer.toggleNeighbourVisibility(), EIOLang.TOGGLE_NEIGHBOUR);
        this.neighbourButton.m_257544_(Tooltip.m_257550_((Component)EIOLang.TOGGLE_NEIGHBOUR.m_6881_().m_130940_(ChatFormatting.WHITE)));
        this.neighbourButton.f_93624_ = show;
        addRenderableWidget.apply((AbstractWidget)this.neighbourButton);
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Vector2i pos = new Vector2i(this.m_252754_(), this.m_252907_());
        this.addedOn.renderSimpleArea(guiGraphics, pos, pos.add(new Vector2i(this.f_93618_, this.f_93619_)));
        RenderSystem.enableDepthTest();
        guiGraphics.m_280163_(IOCONFIG, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, 48, 32);
        RenderSystem.disableDepthTest();
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        boolean state;
        this.configRenderer.f_93624_ = state = this.setPlayerInvVisible.apply(this.playerInvVisible.get() == false) == false;
        this.neighbourButton.f_93624_ = state;
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public record Inset(int left, int right, int top, int bottom) {
    }
}

