/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.capability;

import com.enderio.api.filter.ItemStackFilter;
import com.enderio.core.common.capability.IFilterCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemFilterCapability
implements IFilterCapability<ItemStack>,
ItemStackFilter {
    private static final String NBT_KEY = "IsNbt";
    private static final String INVERTED_KEY = "IsInverted";
    private static final String ENTRIES_KEY = "ItemEntries";
    private final ItemStack container;

    public ItemFilterCapability(ItemStack container, int size) {
        this.container = container;
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = new ListTag();
            for (int i = 0; i < size; ++i) {
                entriesList.add((Object)ItemStack.f_41583_.serializeNBT());
            }
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
    }

    @Override
    public List<ItemStack> getEntries() {
        CompoundTag tag = this.container.m_41784_();
        ArrayList<ItemStack> entries = new ArrayList<ItemStack>();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
            for (Tag entry : entriesList) {
                entries.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)entry)));
            }
        }
        return entries;
    }

    @Override
    public void setEntry(int pSlotId, ItemStack stack) {
        ListTag entriesList;
        CompoundTag tag = this.container.m_41784_();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        } else {
            entriesList = new ListTag();
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
        entriesList.set(pSlotId, (Tag)stack.serializeNBT());
    }

    @Override
    public void setNbt(Boolean nbt) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(NBT_KEY, nbt.booleanValue());
    }

    @Override
    public boolean isNbt() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(NBT_KEY, 1) && tag.m_128471_(NBT_KEY);
    }

    @Override
    public void setInverted(Boolean inverted) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(INVERTED_KEY, inverted.booleanValue());
    }

    @Override
    public boolean isInvert() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(INVERTED_KEY, 1) && tag.m_128471_(INVERTED_KEY);
    }

    @Override
    public boolean test(ItemStack stack) {
        for (ItemStack testStack : this.getEntries()) {
            boolean test = this.isNbt() ? ItemStack.m_150942_((ItemStack)testStack, (ItemStack)stack) : ItemStack.m_41656_((ItemStack)testStack, (ItemStack)stack);
            if (!test) continue;
            return !this.isInvert();
        }
        return this.isInvert();
    }
}

