/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.menu;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.SlotType;
import com.enderio.conduits.common.conduit.block.ConduitBlock;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.init.ConduitMenus;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.enderio.conduits.common.menu.ConduitSlot;
import com.enderio.conduits.common.network.ConduitSelectionPacket;
import com.enderio.core.common.menu.SyncedMenu;
import com.enderio.core.common.network.CoreNetwork;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ConduitMenu
extends SyncedMenu<ConduitBlockEntity> {
    private final List<ConduitSlot> conduitSlots = new ArrayList<ConduitSlot>();
    private Direction direction;
    private ConduitType<?> type;

    public List<ConduitSlot> getConduitSlots() {
        return this.conduitSlots;
    }

    public ConduitMenu(@Nullable ConduitBlockEntity blockEntity, Inventory inventory, int pContainerId, Direction direction, ConduitType type) {
        super(blockEntity, inventory, (MenuType)ConduitMenus.CONDUIT_MENU.get(), pContainerId);
        this.direction = direction;
        this.type = type;
        if (blockEntity != null) {
            IItemHandler conduitItemHandler = blockEntity.getConduitItemHandler();
            for (Direction forDirection : Direction.values()) {
                for (int i = 0; i < 9; ++i) {
                    for (SlotType slotType : SlotType.values()) {
                        ConduitSlot slot = new ConduitSlot(blockEntity.getBundle(), conduitItemHandler, () -> this.direction, forDirection, () -> blockEntity.getBundle().getTypes().indexOf(this.type), i, slotType);
                        this.conduitSlots.add(slot);
                        slot.updateVisibilityPosition();
                        this.m_38897_((Slot)slot);
                    }
                }
            }
        }
        this.addInventorySlots(23, 113);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < this.f_38839_.size() - 36 ? !this.m_38903_(itemstack1, this.f_38839_.size() - 36, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.f_38839_.size() - 36, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.getBlockEntity() != null && ((ConduitBlockEntity)((Object)this.getBlockEntity())).stillValid(player) && (player instanceof ServerPlayer || this.clientValid());
    }

    private boolean clientValid() {
        return ((ConduitBlockEntity)((Object)this.getBlockEntity())).getBundle().getTypes().contains(this.type) && ConduitBlock.canBeOrIsValidConnection((ConduitBlockEntity)((Object)this.getBlockEntity()), this.type, this.direction);
    }

    public static ConduitMenu factory(@Nullable MenuType<ConduitMenu> pMenuType, int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        BlockEntity entity = inventory.f_35978_.m_9236_().m_7702_(buf.m_130135_());
        Direction direction = (Direction)buf.m_130066_(Direction.class);
        ConduitType<?> type = EIOConduitTypes.getById(buf.readInt());
        if (entity instanceof ConduitBlockEntity) {
            ConduitBlockEntity castBlockEntity = (ConduitBlockEntity)entity;
            return new ConduitMenu(castBlockEntity, inventory, pContainerId, direction, type);
        }
        LogManager.getLogger().warn("couldn't find BlockEntity");
        return new ConduitMenu(null, inventory, pContainerId, direction, type);
    }

    public ConduitType<?> getConduitType() {
        return this.type;
    }

    public void setConduitType(ConduitType<?> type) {
        this.type = type;
        CoreNetwork.sendToServer(new ConduitSelectionPacket(EIOConduitTypes.getConduitId(type)));
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void m_6877_(Player player) {
        ServerPlayer serverPlayer;
        super.m_6877_(player);
        if (this.getBlockEntity() != null && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_284548_().m_6907_().stream().filter(p -> p != player).noneMatch(p -> p.f_36096_ instanceof ConduitMenu)) {
            ((ConduitBlockEntity)((Object)this.getBlockEntity())).updateEmptyDynConnection();
        }
    }
}

