/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.item;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ItemStackFilter;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.conduits.common.capability.ExtractionSpeedUpgrade;
import com.enderio.conduits.common.conduit.type.item.ItemConduitData;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemConduitTicker
extends CapabilityAwareConduitTicker<ItemConduitData, IItemHandler> {
    public static ItemConduitTicker INSTANCE = new ItemConduitTicker();

    @Override
    protected void tickCapabilityGraph(ServerLevel level, ConduitType<ItemConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<ItemConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IItemHandler extractHandler = (IItemHandler)extract.capability;
            for (int i = 0; i < extractHandler.getSlots(); ++i) {
                ItemStackFilter itemFilter;
                ResourceFilter resourceFilter;
                ItemStack extractedItem;
                int speed = 4;
                ConduitUpgrade conduitUpgrade = extract.upgrade;
                if (conduitUpgrade instanceof ExtractionSpeedUpgrade) {
                    ExtractionSpeedUpgrade speedUpgrade = (ExtractionSpeedUpgrade)conduitUpgrade;
                    speed *= (int)Math.pow(2.0, speedUpgrade.tier());
                }
                if ((extractedItem = extractHandler.extractItem(i, speed, true)).m_41619_() || (resourceFilter = extract.extractFilter) instanceof ItemStackFilter && !(itemFilter = (ItemStackFilter)resourceFilter).test(extractedItem)) continue;
                ItemConduitData.ItemSidedData sidedExtractData = ((ItemConduitData)extract.data).castTo(ItemConduitData.class).compute(extract.direction);
                if (sidedExtractData.isRoundRobin) {
                    if (inserts.size() <= sidedExtractData.rotatingIndex) {
                        sidedExtractData.rotatingIndex = 0;
                    }
                } else {
                    sidedExtractData.rotatingIndex = 0;
                }
                for (int j = sidedExtractData.rotatingIndex; j < sidedExtractData.rotatingIndex + inserts.size(); ++j) {
                    ItemStack notInserted;
                    ItemStackFilter itemFilter2;
                    ResourceFilter resourceFilter2;
                    int insertIndex = j % inserts.size();
                    CapabilityAwareConduitTicker.CapabilityConnection insert = inserts.get(insertIndex);
                    if (!sidedExtractData.isSelfFeed && extract.direction == insert.direction && extract.data == insert.data || (resourceFilter2 = insert.insertFilter) instanceof ItemStackFilter && !(itemFilter2 = (ItemStackFilter)resourceFilter2).test(extractedItem) || (notInserted = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)insert.capability), (ItemStack)extractedItem, (boolean)false)).m_41613_() >= extractedItem.m_41613_()) continue;
                    extractHandler.extractItem(i, extractedItem.m_41613_() - notInserted.m_41613_(), false);
                    if (!sidedExtractData.isRoundRobin) continue block0;
                    sidedExtractData.rotatingIndex = insertIndex + 1;
                    continue block0;
                }
            }
        }
    }

    @Override
    protected Capability<IItemHandler> getCapability() {
        return ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public int getTickRate() {
        return 20;
    }
}

