/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.fluid;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.FluidStackFilter;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.conduits.common.capability.ExtractionSpeedUpgrade;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidConduitTicker
extends CapabilityAwareConduitTicker<FluidConduitData, IFluidHandler> {
    private final boolean lockFluids;
    private final int fluidRate;

    public FluidConduitTicker(boolean lockFluids, int fluidRate) {
        this.lockFluids = lockFluids;
        this.fluidRate = fluidRate;
    }

    @Override
    public void tickGraph(ServerLevel level, ConduitType<FluidConduitData> type, List<ConduitNode<FluidConduitData>> loadedNodes, ConduitGraph<FluidConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        boolean shouldReset = false;
        for (ConduitNode conduitNode : loadedNodes) {
            FluidConduitData fluidConduitData = ((FluidConduitData)conduitNode.getConduitData()).castTo(FluidConduitData.class);
            if (!fluidConduitData.shouldReset()) continue;
            shouldReset = true;
            fluidConduitData.setShouldReset(false);
        }
        if (shouldReset) {
            for (ConduitNode conduitNode : loadedNodes) {
                ((FluidConduitData)conduitNode.getConduitData()).setLockedFluid(null);
            }
        }
        super.tickGraph(level, type, loadedNodes, graph, coloredRedstoneProvider);
    }

    @Override
    protected void tickCapabilityGraph(ServerLevel level, ConduitType<FluidConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<FluidConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            FluidStackFilter fluidStackFilter;
            Object object;
            IFluidHandler extractHandler = (IFluidHandler)extract.capability;
            FluidConduitData fluidConduitData = ((FluidConduitData)extract.data).castTo(FluidConduitData.class);
            int temp = this.fluidRate;
            ConduitUpgrade conduitUpgrade = extract.upgrade;
            if (conduitUpgrade instanceof ExtractionSpeedUpgrade) {
                ExtractionSpeedUpgrade speedUpgrade = (ExtractionSpeedUpgrade)conduitUpgrade;
                temp *= (int)Math.pow(2.0, speedUpgrade.tier());
            }
            int rate = temp;
            FluidStack extractedFluid = Optional.ofNullable(fluidConduitData.lockedFluid()).map(fluid -> extractHandler.drain(new FluidStack(fluid, rate), IFluidHandler.FluidAction.SIMULATE)).orElseGet(() -> extractHandler.drain(this.fluidRate, IFluidHandler.FluidAction.SIMULATE));
            if (extractedFluid.isEmpty() || (object = extract.extractFilter) instanceof FluidStackFilter && !(fluidStackFilter = (FluidStackFilter)object).test(extractedFluid)) continue;
            int transferred = 0;
            object = inserts.iterator();
            while (object.hasNext()) {
                FluidStack transferredFluid;
                FluidStackFilter fluidStackFilter2;
                CapabilityAwareConduitTicker.CapabilityConnection insert = (CapabilityAwareConduitTicker.CapabilityConnection)object.next();
                ResourceFilter resourceFilter = insert.insertFilter;
                if (resourceFilter instanceof FluidStackFilter && !(fluidStackFilter2 = (FluidStackFilter)resourceFilter).test(extractedFluid) || (transferredFluid = fluidConduitData.lockedFluid() != null ? FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)insert.capability), (IFluidHandler)extractHandler, (FluidStack)new FluidStack(fluidConduitData.lockedFluid(), this.fluidRate - transferred), (boolean)true) : FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)insert.capability), (IFluidHandler)extractHandler, (int)(this.fluidRate - transferred), (boolean)true)).isEmpty()) continue;
                transferred += transferredFluid.getAmount();
                if (this.lockFluids) {
                    for (ConduitNode conduitNode : graph.getNodes()) {
                        Fluid fluid2 = transferredFluid.getFluid();
                        if (fluid2 instanceof FlowingFluid) {
                            FlowingFluid flowing = (FlowingFluid)fluid2;
                            fluid2 = flowing.m_5613_();
                        }
                        ((FluidConduitData)conduitNode.getConduitData()).setLockedFluid(fluid2);
                    }
                }
                if (transferred <= this.fluidRate) continue;
                continue block0;
            }
        }
    }

    @Override
    protected Capability<IFluidHandler> getCapability() {
        return ForgeCapabilities.FLUID_HANDLER;
    }
}

