/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.conduit.WrappedConduitGraph;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.init.ConduitCapabilities;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class ConduitGraphObject<T extends ConduitData<T>>
implements GraphObject<Mergeable.Dummy>,
ConduitNode<T> {
    private final BlockPos pos;
    @Nullable
    private Graph<Mergeable.Dummy> graph = null;
    @Nullable
    private WrappedConduitGraph<T> wrappedGraph = null;
    private final Map<Direction, ConduitNode.IOState> ioStates = new EnumMap<Direction, ConduitNode.IOState>(Direction.class);
    private final T conduitData;
    private final Map<Direction, DynamicConnectionState> connectionStates = new EnumMap<Direction, DynamicConnectionState>(Direction.class);

    public ConduitGraphObject(BlockPos pos, T conduitData) {
        this.pos = pos;
        this.conduitData = conduitData;
    }

    @Nullable
    public Graph<Mergeable.Dummy> getGraph() {
        return this.graph;
    }

    public void setGraph(Graph<Mergeable.Dummy> graph) {
        this.graph = graph;
        this.wrappedGraph = new WrappedConduitGraph(graph);
    }

    @Override
    @Nullable
    public ConduitGraph<T> getParentGraph() {
        return this.wrappedGraph;
    }

    public void pushState(Direction direction, DynamicConnectionState connectionState) {
        this.connectionStates.put(direction, connectionState);
        this.ioStates.put(direction, ConduitNode.IOState.of(connectionState.isInsert() ? connectionState.insertChannel() : null, connectionState.isExtract() ? connectionState.extractChannel() : null, connectionState.control(), connectionState.redstoneChannel()));
    }

    @Override
    public Optional<ConduitNode.IOState> getIOState(Direction direction) {
        return Optional.ofNullable(this.ioStates.get(direction));
    }

    @Override
    public T getConduitData() {
        return this.conduitData;
    }

    public void clearState(Direction direction) {
        this.ioStates.remove(direction);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    @Nullable
    public ConduitUpgrade getUpgrade(Direction direction) {
        return (ConduitUpgrade)this.connectionStates.get(direction).upgradeExtract().getCapability(ConduitCapabilities.CONDUIT_UPGRADE).orElse(null);
    }

    @Override
    @Nullable
    public ResourceFilter getExtractFilter(Direction direction) {
        return (ResourceFilter)this.connectionStates.get(direction).filterExtract().getCapability(EIOCapabilities.FILTER).orElse(null);
    }

    @Override
    @Nullable
    public ResourceFilter getInsertFilter(Direction direction) {
        return (ResourceFilter)this.connectionStates.get(direction).filterInsert().getCapability(EIOCapabilities.FILTER).orElse(null);
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public ConduitGraphObject<T> deepCopy() {
        return new ConduitGraphObject(this.pos, this.conduitData.deepCopy());
    }

    public int hashContents() {
        return Objects.hash(this.pos, this.conduitData, this.ioStates, this.connectionStates);
    }
}

