/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client.gui.conduit;

import com.enderio.EnderIO;
import com.enderio.api.conduit.screen.ConduitScreenExtension;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import com.enderio.core.common.util.TooltipUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public final class FluidConduitScreenExtension
implements ConduitScreenExtension<FluidConduitData> {
    public static final FluidConduitScreenExtension INSTANCE = new FluidConduitScreenExtension();
    private static final ResourceLocation WIDGET_TEXTURE = EnderIO.loc("textures/gui/fluidbackground.png");

    private FluidConduitScreenExtension() {
    }

    @Override
    public List<AbstractWidget> createWidgets(Screen screen, Supplier<FluidConduitData> conduitDataSupplier, ConduitScreenExtension.UpdateExtendedData<FluidConduitData> updateConduitData, Supplier<Direction> direction, Vector2i widgetsStart) {
        return List.of(new FluidWidget(widgetsStart.add(0, 20), () -> ((FluidConduitData)conduitDataSupplier.get()).lockedFluid(), () -> updateConduitData.update(data -> {
            data.setShouldReset(true);
            return data;
        })));
    }

    private static class FluidWidget
    extends AbstractWidget {
        private final Runnable onPress;
        private final Supplier<Fluid> currentFluid;

        FluidWidget(Vector2i pos, Supplier<Fluid> fluid, Runnable onPress) {
            super(pos.x(), pos.y(), 14, 14, (Component)Component.m_237119_());
            this.onPress = onPress;
            this.currentFluid = fluid;
        }

        public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.m_198029_()) {
                MutableComponent tooltip = EIOLang.FLUID_CONDUIT_CHANGE_FLUID1.m_6881_();
                tooltip.m_130946_("\n").m_7220_(EIOLang.FLUID_CONDUIT_CHANGE_FLUID2);
                if (this.currentFluid.get() != null) {
                    tooltip.m_130946_("\n").m_7220_((Component)TooltipUtil.withArgs(EIOLang.FLUID_CONDUIT_CHANGE_FLUID3, this.currentFluid.get().getFluidType().getDescription()));
                }
                this.m_257544_(Tooltip.m_257550_((Component)TooltipUtil.style(tooltip)));
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280218_(WIDGET_TEXTURE, this.m_252754_(), this.m_252907_(), 0, 0, this.f_93618_, this.f_93619_);
            if (this.currentFluid.get() == null) {
                return;
            }
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)this.currentFluid.get());
            ResourceLocation still = props.getStillTexture();
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_);
            if (texture instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.m_118316_(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int atlasWidth = (int)((float)sprite.m_245424_().m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
                int atlasHeight = (int)((float)sprite.m_245424_().m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
                guiGraphics.m_280398_(TextureAtlas.f_118259_, this.m_252754_() + 1, this.m_252907_() + 1, 0, sprite.m_118409_() * (float)atlasWidth, sprite.m_118411_() * (float)atlasHeight, 12, 12, atlasWidth, atlasHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            this.onPress.run();
        }
    }
}

