/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public class CapturedBlocks {
    public static final Codec<CapturedBlocks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf(WORLD_POS_KEY).forGetter(CapturedBlocks::getWorldPos), (App)BlockPos.f_121852_.fieldOf(CENTER_OFFSET_KEY).forGetter(CapturedBlocks::getCenterPos), (App)BoundingBox.f_162354_.fieldOf(BOUNDS_KEY).forGetter(CapturedBlocks::getBounds), (App)BlockInfo.CODEC.listOf().fieldOf("block_infos").forGetter(CapturedBlocks::getBlockInfos), (App)Mirror.f_221524_.fieldOf(MIRROR_KEY).forGetter(CapturedBlocks::getMirror), (App)Rotation.f_221983_.fieldOf(ROTATION_KEY).forGetter(CapturedBlocks::getRotation)).apply((Applicative)instance, CapturedBlocks::new));
    private final BlockPos worldPos;
    private final BlockPos centerOffset;
    private final BoundingBox bounds;
    private final List<BlockInfo> blockInfos;
    private final Mirror mirror;
    private final Rotation rotation;
    @Nullable
    private CapturedBlocks lastTransform = null;
    @Nullable
    private Map<BlockPos, VoxelShape> shapeCache = null;
    boolean compressedForRender = false;
    private static final String PALLETE_KEY = "pallete";
    private static final String DEFAULT_STATE_KEY = "default_state";
    private static final String BLOCKS_KEY = "blocks";
    private static final String STATE_KEY = "state";
    private static final String TAG_KEY = "tag";
    private static final String BOUNDS_KEY = "bounds";
    private static final String WORLD_POS_KEY = "world_pos";
    private static final String CENTER_OFFSET_KEY = "center_offset";
    private static final String MIRROR_KEY = "mirror";
    private static final String ROTATION_KEY = "rotation";

    private CapturedBlocks(BlockPos worldPos, BlockPos centerOffset, BoundingBox bounds, List<BlockInfo> blockInfos, Mirror mirror, Rotation rotation) {
        this.worldPos = worldPos;
        this.centerOffset = centerOffset;
        this.bounds = bounds;
        this.blockInfos = blockInfos;
        this.mirror = mirror;
        this.rotation = rotation;
    }

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB) {
        this(level, cornerA, cornerB, Mirror.NONE, Rotation.NONE);
    }

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB, Mirror mirror, Rotation rotation) {
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
        LinkedList<BlockInfo> infos = new LinkedList<BlockInfo>();
        int minX = bounds.m_162395_();
        int minY = bounds.m_162396_();
        int minZ = bounds.m_162398_();
        int maxX = bounds.m_162399_();
        int maxY = bounds.m_162400_();
        int maxZ = bounds.m_162401_();
        Vec3i bbLength = bounds.m_71053_();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    BlockEntity blockEntity = level.m_7702_(pos);
                    CompoundTag blockEntityTag = blockEntity != null ? blockEntity.m_187482_() : null;
                    BlockPos transformedPos = this.transformPos(new BlockPos(x - minX, y - minY, z - minZ), bbLength, mirror, rotation);
                    infos.add(new BlockInfo(transformedPos, state.m_60715_(mirror).m_60717_(rotation), Optional.ofNullable(blockEntityTag)));
                }
            }
        }
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(minX, minY, minZ), (Vec3i)new Vec3i(minX + bbLength.m_123343_(), maxY, minZ + bbLength.m_123341_()));
            bbLength = bounds.m_71053_();
        }
        this.bounds = bounds;
        this.centerOffset = new BlockPos(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        this.worldPos = new BlockPos(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_());
        this.blockInfos = new ArrayList<BlockInfo>(infos);
        this.mirror = mirror;
        this.rotation = rotation;
    }

    public CapturedBlocks withTransforms(Mirror mirror, Rotation rotation) {
        if (this.lastTransform != null && this.lastTransform.mirror == mirror && this.lastTransform.rotation == rotation) {
            return this.lastTransform;
        }
        BoundingBox bounds = this.bounds;
        LinkedList<BlockInfo> infos = new LinkedList<BlockInfo>();
        int minX = bounds.m_162395_();
        int minY = bounds.m_162396_();
        int minZ = bounds.m_162398_();
        int maxY = bounds.m_162400_();
        Vec3i bbLength = bounds.m_71053_();
        for (BlockInfo info : this.blockInfos) {
            BlockPos pos = info.pos;
            BlockPos transformedPos = this.transformPos(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), bbLength, mirror, rotation);
            infos.add(new BlockInfo(transformedPos, info.state.m_60715_(mirror).m_60717_(rotation), info.blockEntityTag));
        }
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(minX, minY, minZ), (Vec3i)new Vec3i(minX + bbLength.m_123343_(), maxY, minZ + bbLength.m_123341_()));
            bbLength = bounds.m_71053_();
        }
        BlockPos centerOffset = new BlockPos(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        BlockPos worldPos = new BlockPos(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_());
        ArrayList<BlockInfo> blockInfos = new ArrayList<BlockInfo>(infos);
        this.lastTransform = new CapturedBlocks(worldPos, centerOffset, bounds, blockInfos, mirror, rotation);
        return this.lastTransform;
    }

    public void compressForRender(Level level, BlockPos startPos) {
        if (this.compressedForRender) {
            return;
        }
        Map<BlockPos, BlockState> positions = this.blockInfos.stream().collect(Collectors.toMap(BlockInfo::pos, BlockInfo::state));
        Iterator<BlockInfo> it = this.blockInfos.iterator();
        while (it.hasNext()) {
            BlockInfo info = it.next();
            boolean remove = true;
            BlockPos pos = info.pos;
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.m_121945_(dir);
                BlockState offsetState = positions.get(offset);
                if (offsetState != null && offsetState.m_60804_((BlockGetter)level, startPos.m_121955_((Vec3i)offset))) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
        this.compressedForRender = true;
    }

    private BlockPos transformPos(BlockPos pos, Vec3i size, Mirror mirror, Rotation rotation) {
        if (mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (mirror) {
            case LEFT_RIGHT: {
                z = size.m_123343_() - z;
                break;
            }
            case FRONT_BACK: {
                x = size.m_123341_() - x;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                int invZ = size.m_123343_() - z;
                z = x;
                x = invZ;
                break;
            }
            case CLOCKWISE_180: {
                x = size.m_123341_() - x;
                z = size.m_123343_() - z;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                int invX = size.m_123341_() - x;
                x = z;
                z = invX;
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public BlockPos getCenterPos() {
        return this.centerOffset;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public List<BlockInfo> getBlockInfos() {
        return Collections.unmodifiableList(this.blockInfos);
    }

    public Map<BlockPos, VoxelShape> getShapes(Level level, BlockPos worldPos) {
        if (this.shapeCache == null) {
            this.shapeCache = this.getBlockInfos().stream().collect(Collectors.toMap(b -> worldPos.m_121955_((Vec3i)b.pos()), b -> b.state().m_60808_((BlockGetter)level, b.pos())));
        }
        return this.shapeCache;
    }

    public CompoundTag toCompressedTag(RegistryAccess registryAccess) {
        CompoundTag tag = new CompoundTag();
        HashBiMap states = HashBiMap.create();
        HashMap<Object, MutableInt> stateUsage = new HashMap<Object, MutableInt>();
        for (BlockInfo info : this.blockInfos) {
            BlockState state = info.state;
            states.computeIfAbsent((Object)state, arg_0 -> CapturedBlocks.lambda$toCompressedTag$3((BiMap)states, arg_0));
            if (info.blockEntityTag.isPresent()) continue;
            MutableInt count = (MutableInt)stateUsage.get(state);
            if (count == null) {
                stateUsage.put(state, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BlockState mostUsed = stateUsage.entrySet().stream().sorted((a, b) -> ((MutableInt)b.getValue()).compareTo((MutableInt)a.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
        if (mostUsed != null) {
            tag.m_128365_(DEFAULT_STATE_KEY, (Tag)NbtUtils.m_129202_((BlockState)mostUsed));
        }
        ListTag palleteTag = new ListTag();
        for (BlockState state : states.keySet()) {
            palleteTag.add((Object)NbtUtils.m_129202_((BlockState)state));
        }
        tag.m_128365_(PALLETE_KEY, (Tag)palleteTag);
        CompoundTag blocksTag = new CompoundTag();
        for (BlockInfo info : this.blockInfos) {
            if (info.state == mostUsed) continue;
            CompoundTag infoTag = new CompoundTag();
            infoTag.m_128405_(STATE_KEY, ((Integer)states.get((Object)info.state)).intValue());
            if (info.blockEntityTag.isPresent()) {
                infoTag.m_128365_(TAG_KEY, (Tag)info.blockEntityTag.get());
            }
            blocksTag.m_128365_(Long.toString(info.pos.m_121878_()), (Tag)infoTag);
        }
        tag.m_128365_(BLOCKS_KEY, (Tag)blocksTag);
        tag.m_128388_(BOUNDS_KEY, new long[]{BlockPos.m_121882_((int)this.bounds.m_162395_(), (int)this.bounds.m_162396_(), (int)this.bounds.m_162398_()), BlockPos.m_121882_((int)this.bounds.m_162399_(), (int)this.bounds.m_162400_(), (int)this.bounds.m_162401_())});
        tag.m_128356_(WORLD_POS_KEY, this.worldPos.m_121878_());
        tag.m_128356_(CENTER_OFFSET_KEY, this.centerOffset.m_121878_());
        tag.m_128359_(MIRROR_KEY, this.mirror.name());
        tag.m_128359_(ROTATION_KEY, this.rotation.name());
        return tag;
    }

    public static CapturedBlocks fromCompressedTag(RegistryAccess registryAccess, CompoundTag tag) {
        HolderLookup.RegistryLookup blockRegistry = registryAccess.m_175515_(Registries.f_256747_).m_255303_();
        BlockState[] pallete = (BlockState[])tag.m_128437_(PALLETE_KEY, 10).stream().map(arg_0 -> CapturedBlocks.lambda$fromCompressedTag$5((HolderGetter)blockRegistry, arg_0)).toArray(BlockState[]::new);
        BlockState defaultState = tag.m_128425_(DEFAULT_STATE_KEY, 10) ? NbtUtils.m_247651_((HolderGetter)blockRegistry, (CompoundTag)tag.m_128469_(DEFAULT_STATE_KEY)) : null;
        long[] boundsCorners = tag.m_128467_(BOUNDS_KEY);
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)BlockPos.m_122022_((long)boundsCorners[0]), (Vec3i)BlockPos.m_122022_((long)boundsCorners[1]));
        CompoundTag blocksTag = tag.m_128469_(BLOCKS_KEY);
        ArrayList<BlockInfo> infos = new ArrayList<BlockInfo>(bounds.m_71056_() * bounds.m_71057_() * bounds.m_71058_());
        for (int x = 0; x <= bounds.m_71056_() - 1; ++x) {
            for (int z = 0; z <= bounds.m_71058_() - 1; ++z) {
                for (int y = 0; y <= bounds.m_71057_() - 1; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    String l = Long.toString(pos.m_121878_());
                    if (blocksTag.m_128425_(l, 10)) {
                        CompoundTag infoTag = blocksTag.m_128469_(l);
                        BlockState state = pallete[infoTag.m_128451_(STATE_KEY)];
                        Optional<Object> beTag = Optional.ofNullable(infoTag.m_128441_(TAG_KEY) ? infoTag.m_128469_(TAG_KEY) : null);
                        infos.add(new BlockInfo(pos, state, beTag));
                        continue;
                    }
                    if (defaultState == null) continue;
                    infos.add(new BlockInfo(pos, defaultState, Optional.empty()));
                }
            }
        }
        return new CapturedBlocks(BlockPos.m_122022_((long)tag.m_128454_(WORLD_POS_KEY)), BlockPos.m_122022_((long)tag.m_128454_(CENTER_OFFSET_KEY)), bounds, infos, Mirror.valueOf((String)tag.m_128461_(MIRROR_KEY)), Rotation.valueOf((String)tag.m_128461_(ROTATION_KEY)));
    }

    private static /* synthetic */ BlockState lambda$fromCompressedTag$5(HolderGetter blockRegistry, Tag t) {
        return NbtUtils.m_247651_((HolderGetter)blockRegistry, (CompoundTag)((CompoundTag)t));
    }

    private static /* synthetic */ Integer lambda$toCompressedTag$3(BiMap states, BlockState i) {
        return states.size();
    }

    public record BlockInfo(BlockPos pos, BlockState state, Optional<CompoundTag> blockEntityTag) {
        public static final Codec<BlockInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(BlockInfo::pos), (App)BlockState.f_61039_.fieldOf(CapturedBlocks.STATE_KEY).forGetter(BlockInfo::state), (App)CompoundTag.f_128325_.optionalFieldOf(CapturedBlocks.TAG_KEY).forGetter(BlockInfo::blockEntityTag)).apply((Applicative)instance, BlockInfo::new));
    }
}

