/*
 * Decompiled with CFR 0.152.
 */
package tfar.phantomtweaks.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ModDatagen {
    public static void gather(GatherDataEvent e) {
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        DataGenerator generator = e.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        boolean server = e.includeServer();
        generator.addProvider(server, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(ModDatagen::getProvider), Set.of("phantomtweaks")));
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeHolderGetter = context.m_255420_(Registries.f_256952_);
            ForgeBiomeModifiers.AddSpawnsBiomeModifier addSpawn = ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)biomeHolderGetter.m_254956_(BiomeTags.f_215818_), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(EntityType.f_20509_, 5, 1, 4));
            context.m_255272_(ModDatagen.createModifierKey("add_phantom_spawn"), (Object)addSpawn);
        });
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }

    private static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("phantomtweaks", name));
    }
}

