/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class GlareTravelToGlowBerriesTask
extends Behavior<GlareEntity> {
    private static final int MAX_TRAVELLING_TICKS = 300;
    private static final float WITHING_DISTANCE = 1.5f;

    public GlareTravelToGlowBerriesTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), MemoryStatus.VALUE_PRESENT), 300);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        return FriendsAndFoes.getConfig().enableGlareGriefing && !glare.m_21523_() && !glare.m_21827_() && glare.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && glare.canEatGlowBerriesAt(glowBerriesPos.m_122646_()) && glowBerriesPos != null && !glowBerriesPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.flyTowardsGlowBerries(glare);
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        return glowBerriesPos != null && glare.canEatGlowBerriesAt(glowBerriesPos.m_122646_()) && (!glowBerriesPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5) || glare.m_21573_().m_26572_()) && FriendsAndFoes.getConfig().enableGlareGriefing && !glare.m_21523_() && !glare.m_21827_() && glare.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
    }

    protected void keepRunning(ServerLevel world, GlareEntity glare, long time) {
        if (glare.m_21573_().m_26572_()) {
            return;
        }
        this.flyTowardsGlowBerries(glare);
    }

    protected void finishRunning(ServerLevel world, GlareEntity glare, long time) {
        glare.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        if (!(glowBerriesPos == null || glowBerriesPos.m_122646_().m_203195_((Position)glare.m_20182_(), 1.5) && glare.canEatGlowBerriesAt(glowBerriesPos.m_122646_()))) {
            glare.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get());
            GlareBrain.setLocatingGlowBerriesCooldown(glare, TimeUtil.m_145020_((int)10, (int)20));
        }
    }

    private void flyTowardsGlowBerries(GlareEntity glare) {
        GlobalPos glowBerriesPos = glare.getGlowBerriesPos();
        if (glowBerriesPos == null) {
            return;
        }
        BehaviorUtils.m_22617_((LivingEntity)glare, (BlockPos)new BlockPos((Vec3i)glowBerriesPos.m_122646_()), (float)1.0f, (int)0);
    }
}

