/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.entity.GlareEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class GlareStrollTask
extends Behavior<GlareEntity> {
    public GlareStrollTask() {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        return glare.m_21573_().m_26571_();
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.updateCachedPathHolder(glare);
        glare.m_21573_().m_26536_(glare.cachedPathHolder.cachedPath, 1.0);
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        return glare.m_21573_().m_26572_();
    }

    public void updateCachedPathHolder(GlareEntity glare) {
        if (glare.cachedPathHolder.pathTimer > 20 || glare.cachedPathHolder.cachedPath == null || (double)glare.m_6113_() <= 0.05 && glare.cachedPathHolder.pathTimer > 5 || glare.m_20183_().m_123333_((Vec3i)glare.cachedPathHolder.cachedPath.m_77406_()) <= 4) {
            Path newPath;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)glare.m_20183_());
            Level world = glare.m_9236_();
            int currentGroundBlockPosY = this.getGroundBlockPosition(glare).m_123342_();
            boolean isSkyVisible = world.m_45527_(glare.m_20183_());
            boolean isCloseToGround = Math.abs((double)currentGroundBlockPosY - glare.m_20186_()) < 3.0;
            for (int attempt = 0; attempt < 10; ++attempt) {
                int blockRange = 12 - attempt;
                int x = glare.m_20183_().m_123341_() + glare.m_217043_().m_216332_(-blockRange, blockRange);
                int z = glare.m_20183_().m_123343_() + glare.m_217043_().m_216332_(-blockRange, blockRange);
                int y = isSkyVisible ? (isCloseToGround ? glare.m_217043_().m_216332_(currentGroundBlockPosY, currentGroundBlockPosY + blockRange / 2) : glare.m_217043_().m_216332_(currentGroundBlockPosY - blockRange / 4, currentGroundBlockPosY + blockRange / 4)) : (isCloseToGround ? glare.m_217043_().m_216332_(currentGroundBlockPosY, currentGroundBlockPosY + blockRange) : glare.m_217043_().m_216332_(currentGroundBlockPosY - blockRange / 2, currentGroundBlockPosY + blockRange / 2));
                mutable.m_122190_((Vec3i)glare.m_20183_()).m_122178_(x, y, z);
                if (world.m_8055_((BlockPos)mutable).m_60795_()) break;
            }
            glare.cachedPathHolder.cachedPath = newPath = glare.m_21573_().m_7864_((BlockPos)mutable, 1);
            glare.cachedPathHolder.pathTimer = 0;
        } else {
            ++glare.cachedPathHolder.pathTimer;
        }
    }

    private BlockPos getGroundBlockPosition(GlareEntity glare) {
        Level world = glare.m_9236_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)glare.m_20183_());
        int worldBottomY = glare.m_9236_().m_141937_();
        BlockState currentMutableBlockState = world.m_8055_((BlockPos)mutable);
        while (currentMutableBlockState.m_60795_() && mutable.m_123342_() > worldBottomY) {
            mutable.m_122173_(Direction.DOWN);
            currentMutableBlockState = world.m_8055_((BlockPos)mutable);
        }
        return mutable;
    }
}

