/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.config.omegaconfig;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.config.annotation.Description;
import com.faboslav.friendsandfoes.config.omegaconfig.api.Config;
import com.faboslav.friendsandfoes.platform.ConfigDirectory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class OmegaConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static <T extends Config> T register(Class<T> configClass) {
        try {
            Config config = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!OmegaConfig.configExists(config)) {
                config.save();
            } else {
                try {
                    List<String> lines = Files.readAllLines(OmegaConfig.getConfigPath(config));
                    lines.removeIf(line -> line.trim().startsWith("//"));
                    StringBuilder res = new StringBuilder();
                    lines.forEach(res::append);
                    Config object = (Config)GSON.fromJson(res.toString(), configClass);
                    object.save();
                    return (T)object;
                }
                catch (Exception e) {
                    FriendsAndFoes.getLogger().error(e.toString());
                    FriendsAndFoes.getLogger().info(String.format("Encountered an error while reading %s config, falling back to default values.", config.getName()));
                    FriendsAndFoes.getLogger().info(String.format("If this problem persists, delete the config file %s and try again.", config.getName() + "." + config.getExtension()));
                }
            }
            return (T)config;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            throw new RuntimeException("No valid constructor found for: " + configClass.getName());
        }
    }

    public static <T extends Config> void writeConfig(Class<T> configClass, T instance) {
        String json = GSON.toJson(instance);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(json.split("\n")));
        TreeMap<Integer, String> insertions = new TreeMap<Integer, String>();
        HashMap keyToComments = new HashMap();
        for (Field field : configClass.getDeclaredFields()) {
            OmegaConfig.addFieldComments(field);
        }
        for (AnnotatedElement annotatedElement : configClass.getDeclaredClasses()) {
            for (Field field : ((Class)annotatedElement).getDeclaredFields()) {
                OmegaConfig.addFieldComments(field);
            }
        }
        block5: for (int i = 0; i < lines.size(); ++i) {
            String at = (String)lines.get(i);
            for (Map.Entry entry : keyToComments.entrySet()) {
                String key = (String)entry.getKey();
                String comment = (String)entry.getValue();
                if (!at.trim().startsWith(String.format("\"%s\"", key))) continue;
                insertions.put(i + insertions.size(), String.format("%s//%s", OmegaConfig.getStartingWhitespace(at), comment));
                continue block5;
            }
        }
        for (Map.Entry entry : insertions.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            lines.add(key, string);
        }
        StringBuilder res = new StringBuilder();
        lines.forEach(str -> res.append(String.format("%s%n", str)));
        try {
            Path configPath = OmegaConfig.getConfigPath(instance);
            configPath.toFile().getParentFile().mkdirs();
            Files.write(configPath, res.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            FriendsAndFoes.getLogger().error(ioException.toString());
            FriendsAndFoes.getLogger().info(String.format("Write error, using default values for config %s.", configClass));
        }
    }

    private static void addFieldComments(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
            if (annotation instanceof Description) break;
        }
    }

    private static String getStartingWhitespace(String input) {
        int index = -1;
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char at = chars[i];
            if (at == ' ') continue;
            index = i;
            break;
        }
        if (index != -1) {
            return input.substring(0, index);
        }
        return "";
    }

    public static Path getConfigPath(Config config) {
        return Paths.get(ConfigDirectory.getConfigDirectory().toString(), config.getDirectory(), String.format("%s.%s", config.getName(), config.getExtension()));
    }

    public static boolean configExists(Config config) {
        return Files.exists(OmegaConfig.getConfigPath(config), new LinkOption[0]);
    }
}

