/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.tileentity.base;

import com.mrh0.buildersaddition.util.IComparetorOverride;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class BaseChestTileEntity
extends RandomizableContainerBlockEntity
implements IComparetorOverride,
ICapabilityProvider {
    private NonNullList<ItemStack> inv = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            BaseChestTileEntity.this.playSound(state, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            BaseChestTileEntity.this.playSound(state, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int a, int b) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == BaseChestTileEntity.this;
            }
            return false;
        }
    };
    protected LazyOptional<IItemHandlerModifiable> chestHandler;

    public BaseChestTileEntity(BlockEntityType<?> tet, BlockPos pos, BlockState state) {
        super(tet, pos, state);
    }

    public void m_155250_(BlockState p_155251_) {
        super.m_155250_(p_155251_);
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof ChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = ChestBlock.m_51511_((ChestBlock)((ChestBlock)state.m_60734_()), (BlockState)state, (Level)this.m_58904_(), (BlockPos)this.m_58899_(), (boolean)true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void m_142466_(CompoundTag p_155349_) {
        super.m_142466_(p_155349_);
        this.inv = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(p_155349_)) {
            ContainerHelper.m_18980_((CompoundTag)p_155349_, this.inv);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inv);
        }
        super.m_183515_(nbt);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inv;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.inv = itemsIn;
    }

    public void m_5856_(Player p_58616_) {
        if (!this.f_58859_ && !p_58616_.m_5833_()) {
            this.openersCounter.m_155452_(p_58616_, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player p_58614_) {
        if (!this.f_58859_ && !p_58614_.m_5833_()) {
            this.openersCounter.m_155468_(p_58614_, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected abstract void playSound(BlockState var1, SoundEvent var2);

    @Override
    public int getComparetorOverride() {
        return AbstractContainerMenu.m_38938_((Container)this);
    }
}

