/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.tileentity;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.container.SpeakerContainer;
import com.mrh0.buildersaddition.network.IIntData;
import com.mrh0.buildersaddition.tileentity.base.BaseInstrument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SpeakerTileEntity
extends BaseInstrument
implements MenuProvider,
IIntData {
    private int instruments;
    public static int latestNotes = 0;

    public SpeakerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Index.SPEAKER_TILE_ENTITY_TYPE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.buildersaddition.speaker");
    }

    @Override
    public void playNote(int note) {
        if (!((Boolean)Config.MIDI_ENABLED.get()).booleanValue() || !((Boolean)Config.MIDI_SOUND_ENABLED.get()).booleanValue()) {
            return;
        }
        Level world = this.m_58904_();
        BlockPos pos = this.m_58899_();
        if (note > 0 && note <= 24) {
            if (this.isInstrumentActive(0)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12209_.get(), note);
            }
            if (this.isInstrumentActive(1)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12217_.get(), note);
            }
            if (this.isInstrumentActive(2)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12215_.get(), note);
            }
            if (this.isInstrumentActive(3)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12208_.get(), note);
            }
            if (this.isInstrumentActive(11)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12169_.get(), note);
            }
        }
        if (note > 12 && note <= 36 && this.isInstrumentActive(7)) {
            SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12213_.get(), note - 12);
        }
        if (note > 24 && note <= 48) {
            if (this.isInstrumentActive(6)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12211_.get(), note - 24);
            }
            if (this.isInstrumentActive(9)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12167_.get(), note - 24);
            }
            if (this.isInstrumentActive(12)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12170_.get(), note - 24);
            }
            if (this.isInstrumentActive(13)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12171_.get(), note - 24);
            }
            if (this.isInstrumentActive(14)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12216_.get(), note - 24);
            }
            if (this.isInstrumentActive(15)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12214_.get(), note - 24);
            }
        }
        if (note > 36 && note <= 60) {
            if (this.isInstrumentActive(5)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12212_.get(), note - 36);
            }
            if (this.isInstrumentActive(10)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12168_.get(), note - 36);
            }
        }
        if (note > 48) {
            if (this.isInstrumentActive(4)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12210_.get(), note - 48);
            }
            if (this.isInstrumentActive(8)) {
                SpeakerTileEntity.playNote(world, pos, (SoundEvent)SoundEvents.f_12218_.get(), note - 48);
            }
        }
    }

    public static void playNote(Level world, BlockPos pos, SoundEvent evt, int note) {
        if (note < 0) {
            return;
        }
        float f = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        if (latestNotes < (Integer)Config.MIDI_NOTES_PER_SECOND.get()) {
            world.m_5594_((Player)null, pos, evt, SoundSource.RECORDS, 3.0f, f);
            ++latestNotes;
        }
    }

    @Override
    public void updateData(int encoded) {
        this.instruments = encoded;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        this.instruments = nbt.m_128451_("instruments");
        super.m_142466_(nbt);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("instruments", this.instruments);
        super.m_183515_(nbt);
    }

    private int getBit(int n, int k) {
        return n >> k & 1;
    }

    public boolean isInstrumentActive(int index) {
        return this.getBit(this.instruments, index) > 0;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag update = pkt.m_131708_();
        this.handleUpdateTag(update);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return SpeakerContainer.create(windowId, inv, this.m_58899_());
    }
}

