/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.event.opts.BlockOptions;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class VerticalRedstoneDiodeBlock
extends BaseBlock {
    public static final DirectionProperty VERTICAL_FACING = DirectionProperty.m_61546_((String)"vertical_facing", d -> d.m_122434_() == Direction.Axis.Y);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected VerticalRedstoneDiodeBlock(String name, BlockBehaviour.Properties builder) {
        super(name, builder, new BlockOptions().hasItem(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
            case EAST: {
                return EAST_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public boolean isValidPosition(BlockState state, LevelReader world, BlockPos pos) {
        return VerticalRedstoneDiodeBlock.m_49936_((BlockGetter)world, (BlockPos)pos.m_121945_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public void tick(BlockState p_52515_, ServerLevel p_52516_, BlockPos p_52517_, Random p_52518_) {
        if (!this.isLocked((LevelReader)p_52516_, p_52517_, p_52515_)) {
            boolean flag = (Boolean)p_52515_.m_61143_((Property)POWERED);
            boolean flag1 = this.shouldTurnOn((Level)p_52516_, p_52517_, p_52515_);
            if (flag && !flag1) {
                p_52516_.m_7731_(p_52517_, (BlockState)p_52515_.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!flag) {
                p_52516_.m_7731_(p_52517_, (BlockState)p_52515_.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
                if (!flag1) {
                    p_52516_.m_186464_(p_52517_, (Block)this, this.getDelay(p_52515_), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return state.m_60746_(world, pos, side);
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return state.m_61143_((Property)VERTICAL_FACING) == side ? this.getOutputSignal(world, pos, state) : 0;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos otherPos, boolean flag) {
        if (state.m_60710_((LevelReader)world, pos)) {
            this.checkTickOnNeighbor(world, pos, state);
        } else {
            BlockEntity blockentity = state.m_155947_() ? world.m_7702_(pos) : null;
            VerticalRedstoneDiodeBlock.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockentity);
            world.m_7471_(pos, false);
            for (Direction direction : Direction.values()) {
                world.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    protected void checkTickOnNeighbor(Level p_52577_, BlockPos p_52578_, BlockState p_52579_) {
        boolean flag1;
        boolean flag;
        if (!this.isLocked((LevelReader)p_52577_, p_52578_, p_52579_) && (flag = ((Boolean)p_52579_.m_61143_((Property)POWERED)).booleanValue()) != (flag1 = this.shouldTurnOn(p_52577_, p_52578_, p_52579_)) && !p_52577_.m_183326_().m_183588_(p_52578_, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.shouldPrioritize((BlockGetter)p_52577_, p_52578_, p_52579_)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            p_52577_.m_186464_(p_52578_, (Block)this, this.getDelay(p_52579_), tickpriority);
        }
    }

    public boolean isLocked(LevelReader worldIn, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean shouldTurnOn(Level worldIn, BlockPos pos, BlockState state) {
        return this.getInputSignal(worldIn, pos, state) > 0;
    }

    protected int getInputSignal(Level worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.m_121945_(direction);
        int i = worldIn.m_277185_(blockpos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return Math.max(i, blockstate.m_60713_(Blocks.f_50088_) ? (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0);
    }

    protected int getAlternateSignal(LevelReader worldIn, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        Direction direction1 = direction.m_122427_();
        Direction direction2 = direction.m_122428_();
        return Math.max(this.getAlternateSignalAt(worldIn, pos.m_121945_(direction1), direction1), this.getAlternateSignalAt(worldIn, pos.m_121945_(direction2), direction2));
    }

    protected int getAlternateSignalAt(LevelReader worldIn, BlockPos pos, Direction side) {
        BlockState blockstate = worldIn.m_8055_(pos);
        if (this.isAlternateInput(blockstate)) {
            if (blockstate.m_60713_(Blocks.f_50330_)) {
                return 15;
            }
            return blockstate.m_60713_(Blocks.f_50088_) ? ((Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue() : worldIn.m_277075_(pos, side);
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        boolean flag;
        boolean bl = flag = c.m_43720_().f_82480_ - (double)c.m_8083_().m_123342_() - 0.5 < 0.0;
        if (c.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)c.m_8125_())).m_61124_((Property)VERTICAL_FACING, (Comparable)c.m_43719_());
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)c.m_43719_().m_122424_())).m_61124_((Property)VERTICAL_FACING, (Comparable)(flag ? Direction.UP : Direction.DOWN));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity ent, ItemStack stack) {
        if (this.shouldTurnOn(world, pos, state)) {
            world.m_183326_().m_183588_(pos, (Object)this);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean flag) {
        this.updateNeighborsInFront(world, pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, world, pos, newState, isMoving);
            this.updateNeighborsInFront(world, pos, state);
        }
    }

    protected void updateNeighborsInFront(Level world, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)VERTICAL_FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        if (ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)world.m_8055_(pos), EnumSet.of(direction.m_122424_()), (boolean)false).isCanceled()) {
            return;
        }
        world.m_46586_(blockpos, (Block)this, pos);
        world.m_46590_(blockpos, (Block)this, direction);
    }

    protected boolean isAlternateInput(BlockState state) {
        return state.m_60803_();
    }

    protected int getOutputSignal(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return 15;
    }

    public static boolean isDiode(BlockState state) {
        return state.m_60734_() instanceof DiodeBlock || state.m_60734_() instanceof VerticalRedstoneDiodeBlock;
    }

    public boolean shouldPrioritize(BlockGetter worldIn, BlockPos pos, BlockState state) {
        Direction direction = ((Direction)state.m_61143_((Property)VERTICAL_FACING)).m_122424_();
        BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
        return VerticalRedstoneDiodeBlock.isDiode(blockstate) && blockstate.m_61143_((Property)VERTICAL_FACING) != direction;
    }

    protected abstract int getDelay(BlockState var1);
}

