/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.util;

import forge.com.hypherionmc.sdlink.SDLinkConstants;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.managers.CacheManager;
import forge.com.hypherionmc.sdlink.util.ModUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class SDLinkChatUtils {
    private static final Pattern CHANNEL_PATTERN = Pattern.compile("\\[#(.*?)\\]", 2);
    private static final Pattern USER_ROLE_PATTERN = Pattern.compile("\\[@(.*?)\\]", 2);

    public static String parse(String message) {
        String finalMessage;
        block5: {
            finalMessage = message;
            try {
                Matcher m = CHANNEL_PATTERN.matcher(message);
                while (m.find()) {
                    String channelKey = m.group().replace("[", "").replace("]", "");
                    if (CacheManager.getServerChannels().isEmpty() || !CacheManager.getServerChannels().containsKey(channelKey)) continue;
                    finalMessage = finalMessage.replace("[" + channelKey + "]", CacheManager.getServerChannels().get(channelKey));
                }
                Matcher c = USER_ROLE_PATTERN.matcher(message);
                while (c.find()) {
                    String key = c.group().replace("[", "").replace("]", "");
                    if (!CacheManager.getServerRoles().isEmpty() && CacheManager.getServerRoles().containsKey(key)) {
                        finalMessage = finalMessage.replace("[" + key + "]", CacheManager.getServerRoles().get(key));
                    }
                    if (CacheManager.getUserCache().isEmpty() || !CacheManager.getUserCache().containsKey(key)) continue;
                    finalMessage = finalMessage.replace("[" + key + "]", CacheManager.getUserCache().get(key));
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block5;
                SDLinkConstants.LOGGER.error("Failed to parse mention", (Throwable)e);
            }
        }
        return finalMessage;
    }

    public static MutableComponent parseChatLinks(String input) {
        Pattern pattern = Pattern.compile("\\b(?:https?)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|]");
        Matcher matcher = pattern.matcher(input);
        MutableComponent component = Component.m_237119_();
        int lastEnd = 0;
        while (matcher.find()) {
            String url = matcher.group();
            String msg = input.substring(lastEnd, matcher.start());
            component.m_7220_(ModUtils.resolve(msg));
            Style emptyStyle = Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to Open")));
            MutableComponent urlComponent = Component.m_237113_((String)url).m_130948_(emptyStyle);
            component.m_7220_((Component)urlComponent);
            lastEnd = matcher.end();
        }
        String remaining = input.substring(lastEnd);
        component.m_7220_(ModUtils.resolve(remaining));
        return component;
    }
}

