/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.server;

import com.hypherionmc.craterlib.api.event.common.CraterLivingDeathEvent;
import com.hypherionmc.craterlib.api.event.server.CraterAdvancementEvent;
import com.hypherionmc.craterlib.api.event.server.CraterCommandEvent;
import com.hypherionmc.craterlib.api.event.server.CraterPlayerEvent;
import com.hypherionmc.craterlib.api.event.server.CraterRegisterCommandEvent;
import com.hypherionmc.craterlib.api.event.server.CraterServerChatEvent;
import com.hypherionmc.craterlib.api.event.server.CraterServerLifecycleEvent;
import com.hypherionmc.craterlib.api.event.server.MessageBroadcastEvent;
import com.hypherionmc.craterlib.api.event.server.PlayerPreLoginEvent;
import com.hypherionmc.craterlib.core.event.annot.CraterEventListener;
import com.hypherionmc.craterlib.core.network.CraterPacket;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.com.hypherionmc.sdlink.SDLinkConstants;
import forge.com.hypherionmc.sdlink.core.accounts.DiscordAuthor;
import forge.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.discord.BotController;
import forge.com.hypherionmc.sdlink.core.events.SDLinkReadyEvent;
import forge.com.hypherionmc.sdlink.core.managers.CacheManager;
import forge.com.hypherionmc.sdlink.core.messaging.MessageType;
import forge.com.hypherionmc.sdlink.core.messaging.Result;
import forge.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessage;
import forge.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessageBuilder;
import forge.com.hypherionmc.sdlink.core.util.LogReader;
import forge.com.hypherionmc.sdlink.networking.MentionsSyncPacket;
import forge.com.hypherionmc.sdlink.networking.SDLinkNetworking;
import forge.com.hypherionmc.sdlink.platform.SDLinkMCPlatform;
import forge.com.hypherionmc.sdlink.server.commands.DiscordCommand;
import forge.com.hypherionmc.sdlink.server.commands.ReloadEmbedsCommand;
import forge.com.hypherionmc.sdlink.server.commands.WhoisCommand;
import forge.com.hypherionmc.sdlink.util.ModUtils;
import forge.com.hypherionmc.sdlink.util.SDLinkChatUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.UserBanList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ServerEvents {
    private MinecraftServer minecraftServer;
    private final long uptime = System.currentTimeMillis();
    private static ServerEvents events;

    public static ServerEvents getInstance() {
        if (events == null) {
            events = new ServerEvents();
        }
        return events;
    }

    private ServerEvents() {
        BotController.newInstance(SDLinkConstants.LOGGER);
        BotController.INSTANCE.initializeBot();
    }

    @CraterEventListener
    public void onCommandRegister(CraterRegisterCommandEvent event) {
        DiscordCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReloadEmbedsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WhoisCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @CraterEventListener
    public void onServerStarting(CraterServerLifecycleEvent.Starting event) {
        this.minecraftServer = event.getServer();
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStarting) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.START).message(SDLinkConfig.INSTANCE.messageFormatting.serverStarting).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStarted(CraterServerLifecycleEvent.Started event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStarted) {
            BotController.INSTANCE.checkWhiteListing();
            DiscordMessage message = new DiscordMessageBuilder(MessageType.START).message(SDLinkConfig.INSTANCE.messageFormatting.serverStarted).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStopping(CraterServerLifecycleEvent.Stopping event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStopping) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.STOP).message(SDLinkConfig.INSTANCE.messageFormatting.serverStopping).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStoppedEvent(CraterServerLifecycleEvent.Stopped event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStopped) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.STOP).message(SDLinkConfig.INSTANCE.messageFormatting.serverStopped).author(DiscordAuthor.SERVER).afterSend(() -> BotController.INSTANCE.shutdownBot(true)).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerChatEvent(CraterServerChatEvent event) {
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        this.onServerChatEvent(event.getComponent(), event.getPlayer().m_5446_(), SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(event.getPlayer()), event.getPlayer().m_36316_(), false);
    }

    public void onServerChatEvent(Component message, Component user, String uuid, GameProfile gameProfile, boolean fromServer) {
        block6: {
            if (user == null || message == null) {
                return;
            }
            if (!this.canSendMessage()) {
                return;
            }
            try {
                if (SDLinkConfig.INSTANCE.chatConfig.playerMessages) {
                    String username = ModUtils.resolve(user);
                    String msg = ModUtils.resolve(message);
                    if (SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                        msg = SDLinkChatUtils.parse(msg);
                    }
                    DiscordAuthor author = DiscordAuthor.of(username, uuid, gameProfile.getName()).setGameProfile(gameProfile);
                    DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).message(msg).author(!fromServer ? author : DiscordAuthor.SERVER).build();
                    discordMessage.sendMessage();
                }
            }
            catch (Exception e) {
                if (SDLinkConfig.INSTANCE == null || !SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                SDLinkConstants.LOGGER.error("Failed to send Discord Message", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void commandEvent(CraterCommandEvent event) {
        if (!this.canSendMessage()) {
            return;
        }
        String cmd = event.getParseResults().getReader().getString();
        ServerPlayer player = null;
        String uuid = null;
        MutableComponent user = Component.m_237113_((String)"Unknown");
        GameProfile profile = null;
        try {
            player = ((CommandSourceStack)event.getParseResults().getContext().getLastChild().getSource()).m_81375_();
            uuid = SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(player);
            user = player.m_5446_();
            profile = player.m_36316_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (player != null && !SDLinkMCPlatform.INSTANCE.playerIsActive(player)) {
            return;
        }
        String command = cmd.startsWith("/") ? cmd.replaceFirst("/", "") : cmd;
        String cmdName = command.split(" ")[0];
        String username = ModUtils.resolve((Component)user);
        if (username == null || username.equalsIgnoreCase("unknown")) {
            username = "Server";
        }
        if ((cmdName.equalsIgnoreCase("say") || cmdName.equalsIgnoreCase("me")) && SDLinkConfig.INSTANCE.chatConfig.sendSayCommand) {
            String msg = command;
            if (cmdName.equalsIgnoreCase("me")) {
                msg = ModUtils.strip(command, "me");
            }
            if (cmdName.equalsIgnoreCase("say")) {
                msg = ModUtils.strip(command, "say");
            }
            msg = ModUtils.resolve((Component)Component.m_237113_((String)msg));
            DiscordAuthor author = DiscordAuthor.of(username, uuid == null ? "" : uuid, profile != null ? profile.getName() : (player != null ? player.m_7755_().getString() : "server"));
            if (profile != null) {
                author.setGameProfile(profile);
            }
            DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).author(author).message(msg).build();
            discordMessage.sendMessage();
            return;
        }
        if (cmdName.startsWith("tellraw") && SDLinkConfig.INSTANCE.chatConfig.relayTellRaw) {
            CommandContext context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString());
            StringRange selector_range = ((ParsedArgument)event.getParseResults().getContext().getArguments().get("targets")).getRange();
            String target = context.getInput().substring(selector_range.getStart(), selector_range.getEnd());
            if (!target.equals("@a")) {
                return;
            }
            DiscordAuthor author = DiscordAuthor.of(username, uuid == null ? "" : uuid, profile != null ? profile.getName() : player.m_7755_().getString());
            if (profile != null) {
                author.setGameProfile(profile);
            }
            DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).author(author).message(ModUtils.resolve(ComponentArgument.m_87117_((CommandContext)context, (String)"message"))).build();
            discordMessage.sendMessage();
            return;
        }
        if (SDLinkConfig.INSTANCE.chatConfig.ignoredCommands.contains(cmdName)) {
            return;
        }
        if (!SDLinkConfig.INSTANCE.chatConfig.broadcastCommands) {
            return;
        }
        if (!SDLinkConfig.INSTANCE.chatConfig.relayFullCommands) {
            command = command.split(" ")[0];
        }
        DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.COMMAND).author(DiscordAuthor.SERVER).message(SDLinkConfig.INSTANCE.messageFormatting.commands.replace("%player%", username).replace("%command%", command)).build();
        discordMessage.sendMessage();
    }

    @CraterEventListener
    public void playerJoinEvent(CraterPlayerEvent.PlayerLoggedIn event) {
        block4: {
            try {
                if (SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                    MentionsSyncPacket packet = new MentionsSyncPacket(CacheManager.getServerRoles(), CacheManager.getServerChannels(), CacheManager.getUserCache());
                    SDLinkNetworking.networkHandler.sendTo((CraterPacket)packet, event.getPlayer());
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block4;
                SDLinkConstants.LOGGER.error("Failed to sync Mentions to Client", (Throwable)e);
            }
        }
        if (!(this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.playerJoin && SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer()))) {
            return;
        }
        DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.JOIN).message(SDLinkConfig.INSTANCE.messageFormatting.playerJoined.replace("%player%", ModUtils.resolve(event.getPlayer().m_5446_()))).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().m_5446_().getString()).setPlayerAvatar(event.getPlayer().m_36316_().getName(), event.getPlayer().m_20149_())).build();
        discordMessage.sendMessage();
    }

    @CraterEventListener
    public void playerLeaveEvent(CraterPlayerEvent.PlayerLoggedOut event) {
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        if (SDLinkConfig.INSTANCE.accessControl.enabled) {
            try {
                if (SDLinkConfig.INSTANCE.accessControl.banMemberOnMinecraftBan) {
                    MinecraftAccount account = MinecraftAccount.of(event.getPlayer().m_36316_());
                    UserBanList list = this.minecraftServer.m_6846_().m_11295_();
                    if (list.m_11406_(event.getPlayer().m_36316_())) {
                        account.banDiscordMember();
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.playerLeave) {
            String name = ModUtils.resolve(event.getPlayer().m_5446_());
            DiscordMessage message = new DiscordMessageBuilder(MessageType.LEAVE).message(SDLinkConfig.INSTANCE.messageFormatting.playerLeft.replace("%player%", name)).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().m_5446_().getString()).setPlayerAvatar(event.getPlayer().m_36316_().getName(), SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(event.getPlayer()))).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onPlayerDeath(CraterLivingDeathEvent event) {
        ServerPlayer p;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && !SDLinkMCPlatform.INSTANCE.playerIsActive(p = (ServerPlayer)livingEntity)) {
            return;
        }
        livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.deathMessages) {
                String name = ModUtils.resolve(player.m_5446_());
                String msg = ModUtils.resolve(event.getDamageSource().m_6157_((LivingEntity)player));
                if (msg.startsWith(name + " ")) {
                    msg = msg.substring((name + " ").length());
                }
                DiscordMessage message = new DiscordMessageBuilder(MessageType.DEATH).message(SDLinkConfig.INSTANCE.messageFormatting.death.replace("%player%", name).replace("%message%", msg)).author(DiscordAuthor.SERVER.setPlayerName(player.m_5446_().getString()).setPlayerAvatar(player.m_36316_().getName(), player.m_20149_())).build();
                message.sendMessage();
            }
        }
    }

    @CraterEventListener
    public void onPlayerAdvancement(CraterAdvancementEvent event) {
        block4: {
            if (!SDLinkMCPlatform.INSTANCE.playerIsActive((ServerPlayer)event.getPlayer())) {
                return;
            }
            try {
                if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.advancementMessages) {
                    String username = ModUtils.resolve(event.getPlayer().m_5446_());
                    String finalAdvancement = ModUtils.resolve(event.getTitle());
                    String advancementBody = ModUtils.resolve(event.getDescription());
                    DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.ADVANCEMENT).message(SDLinkConfig.INSTANCE.messageFormatting.achievements.replace("%player%", username).replace("%title%", finalAdvancement).replace("%description%", advancementBody)).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().m_5446_().getString()).setPlayerAvatar(event.getPlayer().m_36316_().getName(), event.getPlayer().m_20149_())).build();
                    discordMessage.sendMessage();
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block4;
                SDLinkConstants.LOGGER.error("Failed to send advancement to Discord", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void preLoginEvent(PlayerPreLoginEvent event) {
        if (BotController.INSTANCE == null || !BotController.INSTANCE.isBotReady()) {
            return;
        }
        if (SDLinkConfig.INSTANCE.accessControl.enabled) {
            MinecraftAccount account = MinecraftAccount.of(event.getGameProfile());
            try {
                UserBanList list;
                if (SDLinkConfig.INSTANCE.accessControl.banMemberOnMinecraftBan && (list = this.minecraftServer.m_6846_().m_11295_()).m_11406_(event.getGameProfile())) {
                    account.banDiscordMember();
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Result result = account.canLogin();
            if (result.isError()) {
                event.setMessage((Component)Component.m_237113_((String)result.getMessage()));
            }
        }
    }

    @CraterEventListener
    public void serverBroadcastEvent(MessageBroadcastEvent event) {
        block6: {
            String thread2 = event.getThreadName();
            if (thread2.startsWith("net.minecraft") || thread2.contains("com.hypherionmc")) {
                return;
            }
            if (SDLinkConfig.INSTANCE.ignoreConfig.enabled) {
                if (SDLinkConfig.INSTANCE.ignoreConfig.ignoredThread.stream().anyMatch(thread2::startsWith)) {
                    return;
                }
            }
            if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                SDLinkConstants.LOGGER.info("Relaying message from {}", (Object)thread2);
            }
            try {
                DiscordMessage message = new DiscordMessageBuilder(MessageType.CHAT).author(DiscordAuthor.SERVER).message(ModUtils.resolve(event.getComponent())).build();
                message.sendMessage();
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                SDLinkConstants.LOGGER.error("Failed to broadcast message", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void sdlinkReadyEvent(SDLinkReadyEvent event) {
        if (SDLinkConfig.INSTANCE.chatConfig.sendConsoleMessages) {
            LogReader.init(ModloaderEnvironment.INSTANCE.isDevEnv());
        }
    }

    public boolean canSendMessage() {
        return BotController.INSTANCE != null && BotController.INSTANCE.isBotReady() && SDLinkConfig.INSTANCE != null;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public long getUptime() {
        return this.uptime;
    }
}

