/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.server;

import com.hypherionmc.craterlib.core.platform.CommonPlatform;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.message.MessageReceivedEvent;
import com.mojang.authlib.GameProfile;
import forge.com.hypherionmc.sdlink.SDLinkConstants;
import forge.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import forge.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import forge.com.hypherionmc.sdlink.core.messaging.Result;
import forge.com.hypherionmc.sdlink.core.services.helpers.IMinecraftHelper;
import forge.com.hypherionmc.sdlink.platform.SDLinkMCPlatform;
import forge.com.hypherionmc.sdlink.server.ServerEvents;
import forge.com.hypherionmc.sdlink.util.SDLinkChatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SDLinkMinecraftBridge
implements IMinecraftHelper {
    final Pattern patternStart = Pattern.compile("%(.*?)(?:\\|(.*?))?%", 2);

    @Override
    public void discordMessageReceived(Member member, String s1) {
        block16: {
            AtomicReference<String> user;
            block15: {
                if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                    SDLinkConstants.LOGGER.info("Got message {} from {}", (Object)s1, (Object)member.getEffectiveName());
                }
                user = new AtomicReference<String>(member.getEffectiveName());
                try {
                    if (DatabaseManager.sdlinkDatabase != null) {
                        List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.getCollection(SDLinkAccount.class);
                        accounts.stream().filter(a -> a.getDiscordID().equals(member.getId())).findFirst().ifPresent(u -> user.set(u.getUsername()));
                    }
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block15;
                    SDLinkConstants.LOGGER.error("Failed to load account database: {}", (Object)e.getMessage());
                }
            }
            String prefix = SDLinkConfig.INSTANCE.messageFormatting.mcPrefix;
            MutableComponent component = Component.m_237119_();
            Style baseStyle = Style.f_131099_;
            Matcher matcher = this.patternStart.matcher(prefix);
            int lastAppendPosition = 0;
            while (matcher.find()) {
                String var = matcher.group(1);
                component.m_7220_((Component)Component.m_237113_((String)prefix.substring(lastAppendPosition, matcher.start())).m_130948_(baseStyle));
                lastAppendPosition = matcher.end();
                if (var == null) continue;
                switch (var) {
                    case "color": {
                        baseStyle = baseStyle.m_131148_(TextColor.m_131266_((int)member.getColorRaw()));
                        break;
                    }
                    case "end_color": {
                        baseStyle = baseStyle.m_131140_(ChatFormatting.WHITE);
                    }
                }
                if (!var.equalsIgnoreCase("user")) continue;
                component.m_130946_(user.get()).m_130948_(baseStyle);
            }
            component.m_7220_((Component)Component.m_237113_((String)prefix.substring(lastAppendPosition)).m_130948_(baseStyle));
            try {
                MutableComponent finalComponent = component.m_7220_((Component)SDLinkChatUtils.parseChatLinks(s1));
                ServerEvents.getInstance().getMinecraftServer().m_6846_().m_240416_((Component)finalComponent, false);
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block16;
                SDLinkConstants.LOGGER.error("Failed to send message: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public Result checkWhitelisting() {
        boolean enabled = ServerEvents.getInstance().getMinecraftServer().m_6846_().m_11311_();
        return enabled ? Result.success("Server is using whitelisting") : Result.error("Server side whitelisting is disabled");
    }

    @Override
    public Pair<Integer, Integer> getPlayerCounts() {
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        return Pair.of((Object)server.m_6846_().m_11309_(), (Object)server.m_6846_().m_11310_());
    }

    @Override
    public List<MinecraftAccount> getOnlinePlayers() {
        ArrayList<MinecraftAccount> accounts = new ArrayList<MinecraftAccount>();
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        if (server != null && server.m_6846_() != null) {
            server.m_6846_().m_11314_().forEach(p -> {
                MinecraftAccount account = MinecraftAccount.of(p.m_36316_());
                accounts.add(account);
            });
        }
        return accounts;
    }

    @Override
    public long getServerUptime() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - ServerEvents.getInstance().getUptime());
    }

    @Override
    public String getServerVersion() {
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        if (server == null) {
            return "Unknown - Unknown";
        }
        return server.getServerModName() + " - " + SharedConstants.m_183709_().m_132493_();
    }

    @Override
    public Result executeMinecraftCommand(String command, int permLevel, MessageReceivedEvent event, @Nullable SDLinkAccount account) {
        String name = event.getMember().getEffectiveName();
        if (account != null) {
            name = account.getUsername();
        }
        command = command.replace("%linked_user%", name);
        command = command.replace("%role%", event.getMember().getRoles().stream().map(Role::getName).collect(Collectors.joining()));
        return SDLinkMCPlatform.INSTANCE.executeCommand(command, permLevel, event, name);
    }

    @Override
    public boolean isOnlineMode() {
        MinecraftServer server = CommonPlatform.INSTANCE.getMCServer();
        if (server == null) {
            return false;
        }
        if (ModloaderEnvironment.INSTANCE.isModLoaded("fabrictailor")) {
            return true;
        }
        return server.m_129797_();
    }

    @Override
    public void banPlayer(MinecraftAccount minecraftAccount) {
        MinecraftServer server = CommonPlatform.INSTANCE.getMCServer();
        if (server == null) {
            return;
        }
        GameProfile profile = new GameProfile(minecraftAccount.getUuid(), minecraftAccount.getUsername());
        server.m_6846_().m_11295_().m_11381_((StoredUserEntry)new UserBanListEntry(profile));
    }
}

