/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.networking;

import com.hypherionmc.craterlib.core.abstraction.server.AbstractFriendlyByteBuff;
import com.hypherionmc.craterlib.core.network.CraterPacket;
import forge.com.hypherionmc.sdlink.client.ClientEvents;
import forge.com.hypherionmc.sdlink.client.MentionsController;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MentionsSyncPacket
implements CraterPacket<MentionsSyncPacket> {
    private HashMap<String, String> roles;
    private HashMap<String, String> channelHashMap;
    private HashMap<String, String> users;
    private boolean mentionsEnabled = false;

    public MentionsSyncPacket() {
    }

    public MentionsSyncPacket(HashMap<String, String> roles, HashMap<String, String> channels, HashMap<String, String> users) {
        this.roles = roles;
        this.channelHashMap = channels;
        this.users = users;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        CompoundTag tag = new CompoundTag();
        CompoundTag rolesTag = new CompoundTag();
        CompoundTag channelsTag = new CompoundTag();
        CompoundTag usersTag = new CompoundTag();
        this.roles.forEach((arg_0, arg_1) -> ((CompoundTag)rolesTag).m_128359_(arg_0, arg_1));
        this.channelHashMap.forEach((arg_0, arg_1) -> ((CompoundTag)channelsTag).m_128359_(arg_0, arg_1));
        this.users.forEach((arg_0, arg_1) -> ((CompoundTag)usersTag).m_128359_(arg_0, arg_1));
        tag.m_128365_("roles", (Tag)rolesTag);
        tag.m_128365_("channels", (Tag)channelsTag);
        tag.m_128365_("users", (Tag)usersTag);
        tag.m_128379_("mentionsenabled", SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat);
        AbstractFriendlyByteBuff.write((FriendlyByteBuf)friendlyByteBuf, (CompoundTag)tag);
    }

    public void read(FriendlyByteBuf friendlyByteBuf) {
        CompoundTag tag = friendlyByteBuf.m_130260_();
        if (tag == null) {
            return;
        }
        CompoundTag rolesTag = tag.m_128469_("roles");
        CompoundTag channelsTag = tag.m_128469_("channels");
        CompoundTag usersTag = tag.m_128469_("users");
        this.roles = new HashMap();
        rolesTag.m_128431_().forEach(k -> this.roles.put((String)k, rolesTag.m_128461_(k)));
        this.channelHashMap = new HashMap();
        channelsTag.m_128431_().forEach(k -> this.channelHashMap.put((String)k, channelsTag.m_128461_(k)));
        this.users = new HashMap();
        usersTag.m_128431_().forEach(k -> this.users.put((String)k, usersTag.m_128461_(k)));
        this.mentionsEnabled = tag.m_128471_("mentionsenabled");
    }

    public CraterPacket.PacketHandler<MentionsSyncPacket> createHandler() {
        return new CraterPacket.PacketHandler<MentionsSyncPacket>(){

            public void handle(MentionsSyncPacket mentionsSyncPacket, Player player, Object o) {
                if (MentionsSyncPacket.this.roles != null && !MentionsSyncPacket.this.roles.isEmpty()) {
                    ResourceLocation rrl = new ResourceLocation("sdlink:roles");
                    MentionsController.registerMention(rrl, MentionsSyncPacket.this.roles.keySet(), currentWord -> currentWord.startsWith("[@") || currentWord.startsWith("@"));
                }
                if (MentionsSyncPacket.this.channelHashMap != null && !MentionsSyncPacket.this.channelHashMap.isEmpty()) {
                    ResourceLocation crl = new ResourceLocation("sdlink:channels");
                    MentionsController.registerMention(crl, MentionsSyncPacket.this.channelHashMap.keySet(), currentWord -> currentWord.startsWith("[#") || currentWord.startsWith("#"));
                }
                if (MentionsSyncPacket.this.users != null && !MentionsSyncPacket.this.users.isEmpty()) {
                    ResourceLocation url = new ResourceLocation("sdlink:users");
                    MentionsController.registerMention(url, MentionsSyncPacket.this.users.keySet(), currentWord -> currentWord.startsWith("[@") || currentWord.startsWith("@"));
                }
                ClientEvents.mentionsEnabled = MentionsSyncPacket.this.mentionsEnabled;
            }
        };
    }
}

