/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.util;

import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.discord.BotController;

public class Profiler {
    private final String profilerName;
    private long startTime;
    private boolean hasStarted = false;
    private String message = "";

    private Profiler(String profilerName) {
        this.profilerName = profilerName;
        this.hasStarted = false;
    }

    public static Profiler getProfiler(String name) {
        return new Profiler(name);
    }

    public void start(String message) {
        if (!SDLinkConfig.INSTANCE.generalConfig.debugging) {
            return;
        }
        this.message = message;
        this.startTime = System.nanoTime();
        this.hasStarted = true;
    }

    public void stop() {
        if (!SDLinkConfig.INSTANCE.generalConfig.debugging) {
            return;
        }
        if (!this.hasStarted) {
            BotController.INSTANCE.getLogger().error("[Profiler (" + this.profilerName + ")] was not started");
            return;
        }
        long stopTime = System.nanoTime();
        double seconds = (double)(stopTime - this.startTime) / 1000000.0;
        BotController.INSTANCE.getLogger().info("[Profiler (" + this.profilerName + ")] " + this.message + " took " + seconds + " ms");
        this.hasStarted = false;
    }
}

