/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.discord.commands.slash.verification;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.User;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.OptionType;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.interactions.commands.build.OptionData;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.SlashCommandEvent;
import forge.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import forge.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import forge.com.hypherionmc.sdlink.core.discord.commands.slash.SDLinkSlashCommand;
import forge.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import forge.com.hypherionmc.sdlink.core.messaging.Result;
import java.util.ArrayList;
import java.util.List;

public class StaffUnverifyCommand
extends SDLinkSlashCommand {
    public StaffUnverifyCommand() {
        super(true);
        this.name = "staffunverify";
        this.help = "Unverify another player's Minecraft account";
        this.options = new ArrayList<OptionData>(){
            {
                this.add(new OptionData(OptionType.USER, "discorduser", "The discord user the minecraft account belongs to").setRequired(true));
                this.add(new OptionData(OptionType.STRING, "mcname", "The minecraft account of the linked user").setRequired(true));
            }
        };
    }

    @Override
    protected void execute(SlashCommandEvent event) {
        event.deferReply(true).queue();
        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
        List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.findAll(SDLinkAccount.class);
        if (accounts.isEmpty()) {
            event.getHook().sendMessage("Sorry, but this server does not contain any stored players in its database").setEphemeral(true).queue();
            return;
        }
        String mcname = event.getOption("mcname").getAsString();
        User user = event.getOption("discorduser").getAsUser();
        Member member = event.getGuild().getMemberById(user.getId());
        if (member == null) {
            event.getHook().sendMessage(user.getEffectiveName() + " is not a member of this discord server").setEphemeral(true).queue();
            return;
        }
        MinecraftAccount minecraftAccount = MinecraftAccount.of(mcname);
        Result result = minecraftAccount.unverifyAccount(member, event.getGuild());
        event.getHook().sendMessage(result.getMessage()).setEphemeral(true).queue();
    }
}

