/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.discord;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDA;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.JDABuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.requests.GatewayIntent;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.ChunkingFilter;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.MemberCachePolicy;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.CommandClient;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.command.CommandClientBuilder;
import com.hypherionmc.sdlink.shaded.jagrosh.jdautilities.commons.waiter.EventWaiter;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.discord.commands.CommandManager;
import forge.com.hypherionmc.sdlink.core.discord.events.DiscordEventHandler;
import forge.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import forge.com.hypherionmc.sdlink.core.managers.EmbedManager;
import forge.com.hypherionmc.sdlink.core.managers.WebhookManager;
import forge.com.hypherionmc.sdlink.core.services.SDLinkPlatform;
import forge.com.hypherionmc.sdlink.core.util.EncryptionUtil;
import forge.com.hypherionmc.sdlink.core.util.ThreadedEventManager;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class BotController {
    public static final ScheduledExecutorService taskManager = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    public static BotController INSTANCE;
    private final EventWaiter eventWaiter = new EventWaiter();
    private final Logger logger;
    private JDA _jda;

    private BotController(Logger logger) {
        File oldConfig;
        INSTANCE = this;
        this.logger = logger;
        File newConfigDir = new File("./config/simple-discord-link");
        if (!newConfigDir.exists()) {
            newConfigDir.mkdirs();
        }
        if ((oldConfig = new File("./config/simple-discord-link.toml")).exists()) {
            try {
                FileUtils.moveFile((File)oldConfig, (File)new File(newConfigDir.getAbsolutePath() + File.separator + "simple-discord-link.toml"));
            }
            catch (Exception e) {
                logger.error("Failed to move config file to new location", (Throwable)e);
            }
        }
        new SDLinkConfig();
        DatabaseManager.initialize();
        WebhookManager.init();
        EmbedManager.init();
    }

    public static void newInstance(Logger logger) {
        if (INSTANCE != null) {
            INSTANCE.shutdownBot(false);
        }
        new BotController(logger);
    }

    public void initializeBot() {
        if (SDLinkConfig.INSTANCE == null || !SDLinkConfig.hasConfigLoaded) {
            this.logger.error("Failed to load config. Check your log for errors");
            return;
        }
        if (SDLinkConfig.INSTANCE.botConfig.botToken.isEmpty()) {
            this.logger.error("Missing bot token. Mod will be disabled");
            return;
        }
        if (!SDLinkConfig.INSTANCE.generalConfig.enabled) {
            return;
        }
        try {
            String token = EncryptionUtil.INSTANCE.decrypt(SDLinkConfig.INSTANCE.botConfig.botToken);
            this._jda = JDABuilder.createLight(token, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGE_REACTIONS).setMemberCachePolicy(MemberCachePolicy.ALL).setChunkingFilter(ChunkingFilter.ALL).setBulkDeleteSplittingEnabled(true).setEventManager(new ThreadedEventManager()).build();
            CommandClientBuilder clientBuilder = new CommandClientBuilder();
            clientBuilder.setOwnerId("354707828298088459");
            clientBuilder.setHelpWord("help");
            clientBuilder.useHelpBuilder(false);
            clientBuilder.setActivity(null);
            CommandClient commandClient = clientBuilder.build();
            CommandManager.INSTANCE.register(commandClient);
            this._jda.addEventListener(commandClient, this.eventWaiter, new DiscordEventHandler());
            this._jda.setAutoReconnect(true);
        }
        catch (Exception e) {
            this.logger.error("Failed to connect to discord", (Throwable)e);
        }
    }

    public boolean isBotReady() {
        if (SDLinkConfig.INSTANCE == null) {
            return false;
        }
        if (!SDLinkConfig.INSTANCE.generalConfig.enabled) {
            return false;
        }
        if (this._jda == null) {
            return false;
        }
        if (this._jda.getStatus() == JDA.Status.SHUTTING_DOWN || this._jda.getStatus() == JDA.Status.SHUTDOWN) {
            return false;
        }
        return this._jda.getStatus() == JDA.Status.CONNECTED;
    }

    public void shutdownBot() {
        this.shutdownBot(true);
    }

    public void shutdownBot(boolean forced) {
        if (this._jda != null) {
            this._jda.shutdown();
        }
        WebhookManager.shutdown();
        if (forced) {
            taskManager.schedule(() -> {
                taskManager.shutdownNow();
                System.exit(1);
            }, 10L, TimeUnit.SECONDS);
        }
    }

    public void checkWhiteListing() {
        if (SDLinkConfig.INSTANCE.accessControl.enabled && !SDLinkPlatform.minecraftHelper.checkWhitelisting().isError()) {
            this.getLogger().error("SDLink Access Control is enabled, but so is whitelisting on your server. You need to disable whitelisting to use the AccessControl feature");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public JDA getJDA() {
        return this._jda;
    }

    public EventWaiter getEventWaiter() {
        return this.eventWaiter;
    }
}

