/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.config.impl;

import forge.com.hypherionmc.sdlink.core.messaging.MessageDestination;
import shadow.hypherionmc.moonconfig.core.conversion.Path;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;

public class MessageChannelConfig {
    @Path(value="chat")
    @SpecComment(value="Control where CHAT messages are delivered")
    public DestinationObject chat = DestinationObject.of(MessageDestination.CHAT, false, "default");
    @Path(value="start")
    @SpecComment(value="Control where START messages are delivered")
    public DestinationObject start = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="stop")
    @SpecComment(value="Control where STOP messages are delivered")
    public DestinationObject stop = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="join")
    @SpecComment(value="Control where JOIN messages are delivered")
    public DestinationObject join = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="leave")
    @SpecComment(value="Control where LEAVE messages are delivered")
    public DestinationObject leave = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="advancements")
    @SpecComment(value="Control where ADVANCEMENT messages are delivered")
    public DestinationObject advancements = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="death")
    @SpecComment(value="Control where DEATH messages are delivered")
    public DestinationObject death = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="commands")
    @SpecComment(value="Control where COMMAND messages are delivered")
    public DestinationObject commands = DestinationObject.of(MessageDestination.EVENT, false, "default");
    @Path(value="custom")
    @SpecComment(value="Control where messages that match none of the above are delivered")
    public DestinationObject custom = DestinationObject.of(MessageDestination.EVENT, false, "default");

    public static class DestinationObject {
        @Path(value="channel")
        @SpecComment(value="The Channel the message will be delivered to. Valid entries are CHAT, EVENT, CONSOLE")
        public MessageDestination channel;
        @Path(value="useEmbed")
        @SpecComment(value="Should the message be sent using EMBED style messages")
        public boolean useEmbed;
        @Path(value="embedLayout")
        @SpecComment(value="Embed Layout to use")
        public String embedLayout;

        DestinationObject(MessageDestination destination, boolean useEmbed, String embedLayout) {
            this.channel = destination;
            this.useEmbed = useEmbed;
            this.embedLayout = embedLayout;
        }

        public static DestinationObject of(MessageDestination destination, boolean useEmbed, String embedLayout) {
            return new DestinationObject(destination, useEmbed, embedLayout);
        }
    }
}

