/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.config;

import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.craterlib.core.config.ModuleConfig;
import com.hypherionmc.craterlib.core.config.annotations.NoConfigScreen;
import forge.com.hypherionmc.sdlink.core.config.impl.AccessControl;
import forge.com.hypherionmc.sdlink.core.config.impl.BotConfigSettings;
import forge.com.hypherionmc.sdlink.core.config.impl.ChannelWebhookConfig;
import forge.com.hypherionmc.sdlink.core.config.impl.ChatSettingsConfig;
import forge.com.hypherionmc.sdlink.core.config.impl.GeneralConfigSettings;
import forge.com.hypherionmc.sdlink.core.config.impl.MessageChannelConfig;
import forge.com.hypherionmc.sdlink.core.config.impl.MessageFormatting;
import forge.com.hypherionmc.sdlink.core.config.impl.MessageIgnoreConfig;
import forge.com.hypherionmc.sdlink.core.config.impl.MinecraftCommands;
import forge.com.hypherionmc.sdlink.core.util.EncryptionUtil;
import java.io.File;
import shadow.hypherionmc.moonconfig.core.CommentedConfig;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.conversion.Path;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;
import shadow.hypherionmc.moonconfig.core.file.CommentedFileConfig;

@NoConfigScreen
public class SDLinkConfig
extends ModuleConfig {
    public static transient SDLinkConfig INSTANCE;
    public static transient int configVer;
    public static transient boolean hasConfigLoaded;
    @Path(value="general")
    @SpecComment(value="General Mod Config")
    public GeneralConfigSettings generalConfig = new GeneralConfigSettings();
    @Path(value="botConfig")
    @SpecComment(value="Config specific to the discord bot")
    public BotConfigSettings botConfig = new BotConfigSettings();
    @Path(value="channelsAndWebhooks")
    @SpecComment(value="Config relating to the discord channels and webhooks to use with the mod")
    public ChannelWebhookConfig channelsAndWebhooks = new ChannelWebhookConfig();
    @Path(value="chat")
    @SpecComment(value="Configure which types of messages are delivered to Minecraft/Discord")
    public ChatSettingsConfig chatConfig = new ChatSettingsConfig();
    @Path(value="messageFormatting")
    @SpecComment(value="Change the format in which messages are displayed")
    public MessageFormatting messageFormatting = new MessageFormatting();
    @Path(value="messageDestinations")
    @SpecComment(value="Change in which channel messages appear")
    public MessageChannelConfig messageDestinations = new MessageChannelConfig();
    @Path(value="accessControl")
    @SpecComment(value="Manage access to your server, similar to whitelisting")
    public AccessControl accessControl = new AccessControl();
    @Path(value="minecraftCommands")
    @SpecComment(value="Execute Minecraft commands in Discord")
    public MinecraftCommands linkedCommands = new MinecraftCommands();
    @Path(value="ignoredMessages")
    @SpecComment(value="Configure messages that will be ignored when relaying to discord")
    public MessageIgnoreConfig ignoreConfig = new MessageIgnoreConfig();

    public SDLinkConfig() {
        super("sdlink", "simple-discord-link", "simple-discord-link");
        this.registerAndSetup(this);
    }

    public void registerAndSetup(ModuleConfig config) {
        if (this.getConfigPath().exists() && this.getConfigPath().length() >= 2L) {
            this.migrateConfig(config);
        } else {
            this.saveConfig(config);
        }
        this.performEncryption();
        ConfigController.register_config((ModuleConfig)this);
        this.configReloaded();
    }

    public void migrateConfig(ModuleConfig conf) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)this.getConfigPath()).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)this.getConfigPath()).build();
        config.load();
        if (config.getInt("general.configVersion") == configVer) {
            newConfig.close();
            config.close();
            return;
        }
        new ObjectConverter().toConfig((Object)conf, (Config)newConfig);
        this.updateConfigValues((CommentedConfig)config, (CommentedConfig)newConfig, (CommentedConfig)newConfig, "");
        newConfig.set("general.configVersion", (Object)configVer);
        newConfig.save();
        newConfig.close();
        config.close();
    }

    public void configReloaded() {
        INSTANCE = (SDLinkConfig)((Object)this.loadConfig((Object)this));
        hasConfigLoaded = true;
    }

    private void performEncryption() {
        CommentedFileConfig oldConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)this.getConfigPath()).build();
        oldConfig.load();
        String botToken = (String)oldConfig.getOrElse("botConfig.botToken", (Object)"");
        String chatWebhook = (String)oldConfig.getOrElse("channelsAndWebhooks.webhooks.chatWebhook", (Object)"");
        String eventsWebhook = (String)oldConfig.getOrElse("channelsAndWebhooks.webhooks.eventsWebhook", (Object)"");
        String consoleWebhook = (String)oldConfig.getOrElse("channelsAndWebhooks.webhooks.consoleWebhook", (Object)"");
        if (!botToken.isEmpty()) {
            botToken = EncryptionUtil.INSTANCE.encrypt(botToken);
            oldConfig.set("botConfig.botToken", (Object)botToken);
        }
        if (!chatWebhook.isEmpty()) {
            chatWebhook = EncryptionUtil.INSTANCE.encrypt(chatWebhook);
            oldConfig.set("channelsAndWebhooks.webhooks.chatWebhook", (Object)chatWebhook);
        }
        if (!eventsWebhook.isEmpty()) {
            eventsWebhook = EncryptionUtil.INSTANCE.encrypt(eventsWebhook);
            oldConfig.set("channelsAndWebhooks.webhooks.eventsWebhook", (Object)eventsWebhook);
        }
        if (!consoleWebhook.isEmpty()) {
            consoleWebhook = EncryptionUtil.INSTANCE.encrypt(consoleWebhook);
            oldConfig.set("channelsAndWebhooks.webhooks.consoleWebhook", (Object)consoleWebhook);
        }
        oldConfig.save();
        oldConfig.close();
    }

    static {
        configVer = 14;
        hasConfigLoaded = false;
    }
}

