/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.core.accounts;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Guild;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.UserSnowflake;
import com.hypherionmc.sdlink.shaded.json.JSONException;
import com.hypherionmc.sdlink.shaded.json.JSONObject;
import com.hypherionmc.sdlink.shaded.json.JSONTokener;
import com.hypherionmc.sdlink.shaded.okhttp3.CacheControl;
import com.hypherionmc.sdlink.shaded.okhttp3.OkHttpClient;
import com.hypherionmc.sdlink.shaded.okhttp3.Request;
import com.hypherionmc.sdlink.shaded.okhttp3.Response;
import com.mojang.authlib.GameProfile;
import forge.com.hypherionmc.sdlink.core.accounts.DiscordUser;
import forge.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import forge.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import forge.com.hypherionmc.sdlink.core.discord.BotController;
import forge.com.hypherionmc.sdlink.core.managers.CacheManager;
import forge.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import forge.com.hypherionmc.sdlink.core.managers.RoleManager;
import forge.com.hypherionmc.sdlink.core.messaging.Result;
import forge.com.hypherionmc.sdlink.core.services.SDLinkPlatform;
import forge.com.hypherionmc.sdlink.core.util.Profiler;
import forge.com.hypherionmc.sdlink.core.util.SDLinkUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftAccount {
    private final String username;
    private final UUID uuid;
    private final boolean isOffline;
    private final boolean isValid;

    private MinecraftAccount(String username, UUID uuid, boolean isOffline, boolean isValid) {
        this.username = username;
        this.uuid = uuid;
        this.isOffline = isOffline;
        this.isValid = isValid;
    }

    public static MinecraftAccount of(String username) {
        if (!SDLinkPlatform.minecraftHelper.isOnlineMode()) {
            return MinecraftAccount.offline(username);
        }
        Pair<String, UUID> player = MinecraftAccount.fetchPlayer(username);
        if (player.getRight() == null) {
            return MinecraftAccount.offline(username);
        }
        return new MinecraftAccount((String)player.getLeft(), (UUID)player.getRight(), false, player.getRight() != null);
    }

    public static MinecraftAccount of(GameProfile profile) {
        return new MinecraftAccount(profile.getName(), profile.getId(), profile.getId().version() == 3, true);
    }

    private static MinecraftAccount offline(String username) {
        Pair<String, UUID> player = MinecraftAccount.offlinePlayer(username);
        return new MinecraftAccount((String)player.getLeft(), (UUID)player.getRight(), true, true);
    }

    public static SDLinkAccount getStoredFromUUID(String uuid) {
        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
        return DatabaseManager.sdlinkDatabase.findById((Object)uuid, SDLinkAccount.class);
    }

    private static Pair<String, UUID> fetchPlayer(String name) {
        OkHttpClient client = new OkHttpClient.Builder().callTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).connectTimeout(20L, TimeUnit.SECONDS).build();
        try {
            Request request = new Request.Builder().url("https://api.mojang.com/users/profiles/minecraft/" + name).cacheControl(new CacheControl.Builder().noCache().build()).build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                JSONObject obj = new JSONObject(new JSONTokener(response.body().string()));
                String uuid = "";
                String returnname = name;
                if (obj.has("name") && !obj.getString("name").isEmpty()) {
                    returnname = obj.getString("name");
                }
                if (obj.has("id") && !obj.getString("id").isEmpty()) {
                    uuid = obj.getString("id");
                }
                response.close();
                return Pair.of((Object)returnname, (Object)(uuid.isEmpty() ? null : MinecraftAccount.mojangIdToUUID(uuid)));
            }
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
        }
        return Pair.of((Object)"", null);
    }

    private static UUID mojangIdToUUID(String id) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(id.substring(0, 8));
        strings.add(id.substring(8, 12));
        strings.add(id.substring(12, 16));
        strings.add(id.substring(16, 20));
        strings.add(id.substring(20, 32));
        return UUID.fromString(String.join((CharSequence)"-", strings));
    }

    private static Pair<String, UUID> offlinePlayer(String offlineName) {
        return Pair.of((Object)offlineName, (Object)UUID.nameUUIDFromBytes(("OfflinePlayer:" + offlineName).getBytes(StandardCharsets.UTF_8)));
    }

    public boolean isAccountVerified() {
        SDLinkAccount account = this.getStoredAccount();
        if (account == null || account.getDiscordID() == null) {
            return false;
        }
        return !SDLinkUtils.isNullOrEmpty(account.getDiscordID());
    }

    public SDLinkAccount getStoredAccount() {
        Profiler profiler = Profiler.getProfiler("getStoredAccount");
        profiler.start("Load Stored Account");
        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
        SDLinkAccount account = DatabaseManager.sdlinkDatabase.findById((Object)this.uuid.toString(), SDLinkAccount.class);
        profiler.stop();
        return account == null ? this.newDBEntry() : account;
    }

    @NotNull
    public SDLinkAccount newDBEntry() {
        SDLinkAccount account = new SDLinkAccount();
        account.setUsername(this.username);
        account.setUuid(this.uuid.toString());
        account.setDiscordID(null);
        account.setVerifyCode(null);
        account.setOffline(this.isOffline);
        DatabaseManager.sdlinkDatabase.upsert(account);
        DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
        return account;
    }

    @NotNull
    public String getDiscordName() {
        SDLinkAccount account = this.getStoredAccount();
        if (account == null || SDLinkUtils.isNullOrEmpty(account.getDiscordID())) {
            return "Unlinked";
        }
        DiscordUser user = this.getDiscordUser();
        return user == null ? "Unlinked" : user.getEffectiveName();
    }

    @Nullable
    public DiscordUser getDiscordUser() {
        Profiler profiler = Profiler.getProfiler("getDiscordUser");
        profiler.start("Loading Discord User");
        SDLinkAccount storedAccount = this.getStoredAccount();
        if (storedAccount == null || SDLinkUtils.isNullOrEmpty(storedAccount.getDiscordID())) {
            return null;
        }
        if (CacheManager.getDiscordMembers().isEmpty()) {
            return null;
        }
        Optional<Member> member = CacheManager.getDiscordMembers().stream().filter(m -> m.getId().equalsIgnoreCase(storedAccount.getDiscordID())).findFirst();
        profiler.stop();
        return member.map(value -> DiscordUser.of(value.getEffectiveName(), value.getEffectiveAvatarUrl(), value.getIdLong(), value.getAsMention())).orElse(null);
    }

    public Result verifyAccount(Member member, Guild guild) {
        block7: {
            block6: {
                SDLinkAccount account = this.getStoredAccount();
                if (account == null) {
                    return Result.error("We couldn't find your Minecraft account. Please ask the staff for assistance");
                }
                account.setDiscordID(member.getId());
                account.setVerifyCode(null);
                try {
                    DatabaseManager.sdlinkDatabase.upsert(account);
                    DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                    e.printStackTrace();
                }
            }
            if (RoleManager.getVerifiedRole() != null) {
                try {
                    guild.addRoleToMember(UserSnowflake.fromId(member.getId()), RoleManager.getVerifiedRole()).queue();
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block7;
                    e.printStackTrace();
                }
            }
        }
        return Result.success("Your account has been verified");
    }

    public Result unverifyAccount(Member member, Guild guild) {
        block7: {
            block6: {
                SDLinkAccount account = this.getStoredAccount();
                if (account == null) {
                    return Result.error("We couldn't find your Minecraft account. Please ask the staff for assistance");
                }
                account.setDiscordID(null);
                account.setVerifyCode(null);
                try {
                    DatabaseManager.sdlinkDatabase.upsert(account);
                    DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                    e.printStackTrace();
                }
            }
            if (RoleManager.getVerifiedRole() != null) {
                try {
                    guild.removeRoleFromMember(UserSnowflake.fromId(member.getId()), RoleManager.getVerifiedRole()).queue();
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block7;
                    e.printStackTrace();
                }
            }
        }
        return Result.success("Your account has been un-verified");
    }

    public Result canLogin() {
        if (!SDLinkConfig.INSTANCE.accessControl.enabled) {
            return Result.success("");
        }
        SDLinkAccount account = this.getStoredAccount();
        if (account == null) {
            return Result.error("Failed to load your account");
        }
        if (!this.isAccountVerified()) {
            if (SDLinkUtils.isNullOrEmpty(account.getVerifyCode())) {
                int code = SDLinkUtils.intInRange(1000, 9999);
                account.setVerifyCode(String.valueOf(code));
                DatabaseManager.sdlinkDatabase.upsert(account);
                DatabaseManager.sdlinkDatabase.reloadCollection("verifiedaccounts");
                return Result.error(SDLinkConfig.INSTANCE.accessControl.verificationMessages.accountVerify.replace("{code}", String.valueOf(code)));
            }
            return Result.error(SDLinkConfig.INSTANCE.accessControl.verificationMessages.accountVerify.replace("{code}", account.getVerifyCode()));
        }
        Result result = this.checkAccessControl();
        if (result.isError()) {
            switch (result.getMessage()) {
                case "notFound": {
                    return Result.error("Account not found in server database");
                }
                case "noGuildFound": {
                    return Result.error("No Discord Server Found");
                }
                case "memberNotFound": {
                    return Result.error(SDLinkConfig.INSTANCE.accessControl.verificationMessages.nonMember);
                }
                case "rolesNotLoaded": {
                    return Result.error("Server has required roles configured, but no discord roles were loaded. Please notify the server owner");
                }
                case "accessDeniedByRole": {
                    return Result.error(SDLinkConfig.INSTANCE.accessControl.verificationMessages.roleDenied);
                }
                case "rolesNotFound": {
                    return Result.error(SDLinkConfig.INSTANCE.accessControl.verificationMessages.requireRoles.replace("{roles}", ArrayUtils.toString(RoleManager.getVerificationRoles().stream().map(Role::getName).toList())));
                }
            }
        }
        return Result.success("");
    }

    public Result checkAccessControl() {
        DiscordUser user;
        if (!SDLinkConfig.INSTANCE.accessControl.enabled) {
            return Result.success("pass");
        }
        SDLinkAccount account = this.getStoredAccount();
        if (account == null) {
            return Result.error("notFound");
        }
        if (SDLinkUtils.isNullOrEmpty(account.getDiscordID())) {
            return Result.error("notVerified");
        }
        if (SDLinkConfig.INSTANCE.accessControl.requireDiscordMembership && (user = this.getDiscordUser()) == null) {
            return Result.error("memberNotFound");
        }
        if (!SDLinkConfig.INSTANCE.accessControl.requiredRoles.isEmpty() || !SDLinkConfig.INSTANCE.accessControl.deniedRoles.isEmpty()) {
            Profiler profiler = Profiler.getProfiler("checkRequiredRoles");
            profiler.start("Checking Required Roles");
            AtomicBoolean anyFound = new AtomicBoolean(false);
            AtomicBoolean deniedFound = new AtomicBoolean(false);
            Optional<Member> member = CacheManager.getDiscordMembers().stream().filter(m -> m.getId().equals(account.getDiscordID())).findFirst();
            member.ifPresent(m -> m.getRoles().forEach(r -> {
                if (RoleManager.getDeniedRoles().stream().anyMatch(role -> r.getIdLong() == role.getIdLong()) && !deniedFound.get()) {
                    deniedFound.set(true);
                }
                if (RoleManager.getVerificationRoles().stream().anyMatch(role -> role.getIdLong() == r.getIdLong()) && !anyFound.get()) {
                    anyFound.set(true);
                }
            }));
            profiler.stop();
            if (deniedFound.get() && !RoleManager.getDeniedRoles().isEmpty()) {
                return Result.error("accessDeniedByRole");
            }
            if (!anyFound.get() && !RoleManager.getVerificationRoles().isEmpty()) {
                return Result.error("rolesNotFound");
            }
            if (member.isEmpty()) {
                return Result.error("memberNotFound");
            }
        }
        return Result.success("pass");
    }

    public void banDiscordMember() {
        if (!SDLinkConfig.INSTANCE.accessControl.banMemberOnMinecraftBan) {
            return;
        }
        DiscordUser user = this.getDiscordUser();
        if (user == null) {
            return;
        }
        try {
            BotController.INSTANCE.getJDA().getGuilds().get(0).ban(UserSnowflake.fromId(user.getUserId()), 7, TimeUnit.DAYS).queue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getUsername() {
        return this.username;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isOffline() {
        return this.isOffline;
    }
}

