/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hypherionmc.sdlink.client;

import forge.com.hypherionmc.sdlink.client.MentionCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class MentionsController {
    private static final Map<ResourceLocation, Collection<String>> mentions = new LinkedHashMap<ResourceLocation, Collection<String>>();
    private static final Map<ResourceLocation, MentionCondition> mentionConditions = new LinkedHashMap<ResourceLocation, MentionCondition>();
    private static boolean lastMentionConditional = true;

    public static void registerMention(ResourceLocation mentionClass, Collection<String> suggestions, MentionCondition condition) {
        mentions.put(mentionClass, suggestions);
        mentionConditions.put(mentionClass, condition);
    }

    public static Collection<String> getMentions(String currentWord) {
        ArrayList<String> applicableMentions = new ArrayList<String>();
        lastMentionConditional = false;
        mentionConditions.forEach((mention, condition) -> {
            boolean shouldSuggest = condition.shouldAddMention(currentWord);
            if (!shouldSuggest) {
                return;
            }
            if (!lastMentionConditional && condition != MentionCondition.ALWAYS) {
                lastMentionConditional = true;
            }
            applicableMentions.addAll(mentions.get(mention));
        });
        return applicableMentions;
    }

    public static boolean isLastMentionConditional() {
        return lastMentionConditional;
    }
}

