/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.server;

import com.hypherionmc.craterlib.api.event.common.CraterLivingDeathEvent;
import com.hypherionmc.craterlib.api.event.server.CraterAdvancementEvent;
import com.hypherionmc.craterlib.api.event.server.CraterCommandEvent;
import com.hypherionmc.craterlib.api.event.server.CraterPlayerEvent;
import com.hypherionmc.craterlib.api.event.server.CraterRegisterCommandEvent;
import com.hypherionmc.craterlib.api.event.server.CraterServerChatEvent;
import com.hypherionmc.craterlib.api.event.server.CraterServerLifecycleEvent;
import com.hypherionmc.craterlib.api.event.server.MessageBroadcastEvent;
import com.hypherionmc.craterlib.api.event.server.PlayerPreLoginEvent;
import com.hypherionmc.craterlib.core.event.annot.CraterEventListener;
import com.hypherionmc.craterlib.core.network.CraterPacket;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fabric.com.hypherionmc.sdlink.SDLinkConstants;
import fabric.com.hypherionmc.sdlink.core.accounts.DiscordAuthor;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.discord.BotController;
import fabric.com.hypherionmc.sdlink.core.events.SDLinkReadyEvent;
import fabric.com.hypherionmc.sdlink.core.managers.CacheManager;
import fabric.com.hypherionmc.sdlink.core.messaging.MessageType;
import fabric.com.hypherionmc.sdlink.core.messaging.Result;
import fabric.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessage;
import fabric.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessageBuilder;
import fabric.com.hypherionmc.sdlink.core.util.LogReader;
import fabric.com.hypherionmc.sdlink.networking.MentionsSyncPacket;
import fabric.com.hypherionmc.sdlink.networking.SDLinkNetworking;
import fabric.com.hypherionmc.sdlink.platform.SDLinkMCPlatform;
import fabric.com.hypherionmc.sdlink.server.commands.DiscordCommand;
import fabric.com.hypherionmc.sdlink.server.commands.ReloadEmbedsCommand;
import fabric.com.hypherionmc.sdlink.server.commands.WhoisCommand;
import fabric.com.hypherionmc.sdlink.util.ModUtils;
import fabric.com.hypherionmc.sdlink.util.SDLinkChatUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3335;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class ServerEvents {
    private MinecraftServer minecraftServer;
    private final long uptime = System.currentTimeMillis();
    private static ServerEvents events;

    public static ServerEvents getInstance() {
        if (events == null) {
            events = new ServerEvents();
        }
        return events;
    }

    private ServerEvents() {
        BotController.newInstance(SDLinkConstants.LOGGER);
        BotController.INSTANCE.initializeBot();
    }

    @CraterEventListener
    public void onCommandRegister(CraterRegisterCommandEvent event) {
        DiscordCommand.register((CommandDispatcher<class_2168>)event.getDispatcher());
        ReloadEmbedsCommand.register((CommandDispatcher<class_2168>)event.getDispatcher());
        WhoisCommand.register((CommandDispatcher<class_2168>)event.getDispatcher());
    }

    @CraterEventListener
    public void onServerStarting(CraterServerLifecycleEvent.Starting event) {
        this.minecraftServer = event.getServer();
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStarting) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.START).message(SDLinkConfig.INSTANCE.messageFormatting.serverStarting).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStarted(CraterServerLifecycleEvent.Started event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStarted) {
            BotController.INSTANCE.checkWhiteListing();
            DiscordMessage message = new DiscordMessageBuilder(MessageType.START).message(SDLinkConfig.INSTANCE.messageFormatting.serverStarted).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStopping(CraterServerLifecycleEvent.Stopping event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStopping) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.STOP).message(SDLinkConfig.INSTANCE.messageFormatting.serverStopping).author(DiscordAuthor.SERVER).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerStoppedEvent(CraterServerLifecycleEvent.Stopped event) {
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.serverStopped) {
            DiscordMessage message = new DiscordMessageBuilder(MessageType.STOP).message(SDLinkConfig.INSTANCE.messageFormatting.serverStopped).author(DiscordAuthor.SERVER).afterSend(() -> BotController.INSTANCE.shutdownBot(true)).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onServerChatEvent(CraterServerChatEvent event) {
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        this.onServerChatEvent(event.getComponent(), event.getPlayer().method_5476(), SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(event.getPlayer()), event.getPlayer().method_7334(), false);
    }

    public void onServerChatEvent(class_2561 message, class_2561 user, String uuid, GameProfile gameProfile, boolean fromServer) {
        block6: {
            if (user == null || message == null) {
                return;
            }
            if (!this.canSendMessage()) {
                return;
            }
            try {
                if (SDLinkConfig.INSTANCE.chatConfig.playerMessages) {
                    String username = ModUtils.resolve(user);
                    String msg = ModUtils.resolve(message);
                    if (SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                        msg = SDLinkChatUtils.parse(msg);
                    }
                    DiscordAuthor author = DiscordAuthor.of(username, uuid, gameProfile.getName()).setGameProfile(gameProfile);
                    DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).message(msg).author(!fromServer ? author : DiscordAuthor.SERVER).build();
                    discordMessage.sendMessage();
                }
            }
            catch (Exception e) {
                if (SDLinkConfig.INSTANCE == null || !SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                SDLinkConstants.LOGGER.error("Failed to send Discord Message", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void commandEvent(CraterCommandEvent event) {
        if (!this.canSendMessage()) {
            return;
        }
        String cmd = event.getParseResults().getReader().getString();
        class_3222 player = null;
        String uuid = null;
        class_5250 user = class_2561.method_43470((String)"Unknown");
        GameProfile profile = null;
        try {
            player = ((class_2168)event.getParseResults().getContext().getLastChild().getSource()).method_9207();
            uuid = SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(player);
            user = player.method_5476();
            profile = player.method_7334();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (player != null && !SDLinkMCPlatform.INSTANCE.playerIsActive(player)) {
            return;
        }
        String command = cmd.startsWith("/") ? cmd.replaceFirst("/", "") : cmd;
        String cmdName = command.split(" ")[0];
        String username = ModUtils.resolve((class_2561)user);
        if (username == null || username.equalsIgnoreCase("unknown")) {
            username = "Server";
        }
        if ((cmdName.equalsIgnoreCase("say") || cmdName.equalsIgnoreCase("me")) && SDLinkConfig.INSTANCE.chatConfig.sendSayCommand) {
            String msg = command;
            if (cmdName.equalsIgnoreCase("me")) {
                msg = ModUtils.strip(command, "me");
            }
            if (cmdName.equalsIgnoreCase("say")) {
                msg = ModUtils.strip(command, "say");
            }
            msg = ModUtils.resolve((class_2561)class_2561.method_43470((String)msg));
            DiscordAuthor author = DiscordAuthor.of(username, uuid == null ? "" : uuid, profile != null ? profile.getName() : (player != null ? player.method_5477().getString() : "server"));
            if (profile != null) {
                author.setGameProfile(profile);
            }
            DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).author(author).message(msg).build();
            discordMessage.sendMessage();
            return;
        }
        if (cmdName.startsWith("tellraw") && SDLinkConfig.INSTANCE.chatConfig.relayTellRaw) {
            CommandContext context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString());
            StringRange selector_range = ((ParsedArgument)event.getParseResults().getContext().getArguments().get("targets")).getRange();
            String target = context.getInput().substring(selector_range.getStart(), selector_range.getEnd());
            if (!target.equals("@a")) {
                return;
            }
            DiscordAuthor author = DiscordAuthor.of(username, uuid == null ? "" : uuid, profile != null ? profile.getName() : player.method_5477().getString());
            if (profile != null) {
                author.setGameProfile(profile);
            }
            DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.CHAT).author(author).message(ModUtils.resolve(class_2178.method_9280((CommandContext)context, (String)"message"))).build();
            discordMessage.sendMessage();
            return;
        }
        if (SDLinkConfig.INSTANCE.chatConfig.ignoredCommands.contains(cmdName)) {
            return;
        }
        if (!SDLinkConfig.INSTANCE.chatConfig.broadcastCommands) {
            return;
        }
        if (!SDLinkConfig.INSTANCE.chatConfig.relayFullCommands) {
            command = command.split(" ")[0];
        }
        DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.COMMAND).author(DiscordAuthor.SERVER).message(SDLinkConfig.INSTANCE.messageFormatting.commands.replace("%player%", username).replace("%command%", command)).build();
        discordMessage.sendMessage();
    }

    @CraterEventListener
    public void playerJoinEvent(CraterPlayerEvent.PlayerLoggedIn event) {
        block4: {
            try {
                if (SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                    MentionsSyncPacket packet = new MentionsSyncPacket(CacheManager.getServerRoles(), CacheManager.getServerChannels(), CacheManager.getUserCache());
                    SDLinkNetworking.networkHandler.sendTo((CraterPacket)packet, event.getPlayer());
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block4;
                SDLinkConstants.LOGGER.error("Failed to sync Mentions to Client", (Throwable)e);
            }
        }
        if (!(this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.playerJoin && SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer()))) {
            return;
        }
        DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.JOIN).message(SDLinkConfig.INSTANCE.messageFormatting.playerJoined.replace("%player%", ModUtils.resolve(event.getPlayer().method_5476()))).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().method_5476().getString()).setPlayerAvatar(event.getPlayer().method_7334().getName(), event.getPlayer().method_5845())).build();
        discordMessage.sendMessage();
    }

    @CraterEventListener
    public void playerLeaveEvent(CraterPlayerEvent.PlayerLoggedOut event) {
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        if (SDLinkConfig.INSTANCE.accessControl.enabled) {
            try {
                if (SDLinkConfig.INSTANCE.accessControl.banMemberOnMinecraftBan) {
                    MinecraftAccount account = MinecraftAccount.of(event.getPlayer().method_7334());
                    class_3335 list = this.minecraftServer.method_3760().method_14563();
                    if (list.method_14650(event.getPlayer().method_7334())) {
                        account.banDiscordMember();
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!SDLinkMCPlatform.INSTANCE.playerIsActive(event.getPlayer())) {
            return;
        }
        if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.playerLeave) {
            String name = ModUtils.resolve(event.getPlayer().method_5476());
            DiscordMessage message = new DiscordMessageBuilder(MessageType.LEAVE).message(SDLinkConfig.INSTANCE.messageFormatting.playerLeft.replace("%player%", name)).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().method_5476().getString()).setPlayerAvatar(event.getPlayer().method_7334().getName(), SDLinkMCPlatform.INSTANCE.getPlayerSkinUUID(event.getPlayer()))).build();
            message.sendMessage();
        }
    }

    @CraterEventListener
    public void onPlayerDeath(CraterLivingDeathEvent event) {
        class_3222 p;
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_3222 && !SDLinkMCPlatform.INSTANCE.playerIsActive(p = (class_3222)class_13092)) {
            return;
        }
        class_13092 = event.getEntity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.deathMessages) {
                String name = ModUtils.resolve(player.method_5476());
                String msg = ModUtils.resolve(event.getDamageSource().method_5506((class_1309)player));
                if (msg.startsWith(name + " ")) {
                    msg = msg.substring((name + " ").length());
                }
                DiscordMessage message = new DiscordMessageBuilder(MessageType.DEATH).message(SDLinkConfig.INSTANCE.messageFormatting.death.replace("%player%", name).replace("%message%", msg)).author(DiscordAuthor.SERVER.setPlayerName(player.method_5476().getString()).setPlayerAvatar(player.method_7334().getName(), player.method_5845())).build();
                message.sendMessage();
            }
        }
    }

    @CraterEventListener
    public void onPlayerAdvancement(CraterAdvancementEvent event) {
        block4: {
            if (!SDLinkMCPlatform.INSTANCE.playerIsActive((class_3222)event.getPlayer())) {
                return;
            }
            try {
                if (this.canSendMessage() && SDLinkConfig.INSTANCE.chatConfig.advancementMessages) {
                    String username = ModUtils.resolve(event.getPlayer().method_5476());
                    String finalAdvancement = ModUtils.resolve(event.getTitle());
                    String advancementBody = ModUtils.resolve(event.getDescription());
                    DiscordMessage discordMessage = new DiscordMessageBuilder(MessageType.ADVANCEMENT).message(SDLinkConfig.INSTANCE.messageFormatting.achievements.replace("%player%", username).replace("%title%", finalAdvancement).replace("%description%", advancementBody)).author(DiscordAuthor.SERVER.setPlayerName(event.getPlayer().method_5476().getString()).setPlayerAvatar(event.getPlayer().method_7334().getName(), event.getPlayer().method_5845())).build();
                    discordMessage.sendMessage();
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block4;
                SDLinkConstants.LOGGER.error("Failed to send advancement to Discord", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void preLoginEvent(PlayerPreLoginEvent event) {
        if (BotController.INSTANCE == null || !BotController.INSTANCE.isBotReady()) {
            return;
        }
        if (SDLinkConfig.INSTANCE.accessControl.enabled) {
            MinecraftAccount account = MinecraftAccount.of(event.getGameProfile());
            try {
                class_3335 list;
                if (SDLinkConfig.INSTANCE.accessControl.banMemberOnMinecraftBan && (list = this.minecraftServer.method_3760().method_14563()).method_14650(event.getGameProfile())) {
                    account.banDiscordMember();
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Result result = account.canLogin();
            if (result.isError()) {
                event.setMessage((class_2561)class_2561.method_43470((String)result.getMessage()));
            }
        }
    }

    @CraterEventListener
    public void serverBroadcastEvent(MessageBroadcastEvent event) {
        block6: {
            String thread2 = event.getThreadName();
            if (thread2.startsWith("net.minecraft") || thread2.contains("com.hypherionmc")) {
                return;
            }
            if (SDLinkConfig.INSTANCE.ignoreConfig.enabled) {
                if (SDLinkConfig.INSTANCE.ignoreConfig.ignoredThread.stream().anyMatch(thread2::startsWith)) {
                    return;
                }
            }
            if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                SDLinkConstants.LOGGER.info("Relaying message from {}", (Object)thread2);
            }
            try {
                DiscordMessage message = new DiscordMessageBuilder(MessageType.CHAT).author(DiscordAuthor.SERVER).message(ModUtils.resolve(event.getComponent())).build();
                message.sendMessage();
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                SDLinkConstants.LOGGER.error("Failed to broadcast message", (Throwable)e);
            }
        }
    }

    @CraterEventListener
    public void sdlinkReadyEvent(SDLinkReadyEvent event) {
        if (SDLinkConfig.INSTANCE.chatConfig.sendConsoleMessages) {
            LogReader.init(ModloaderEnvironment.INSTANCE.isDevEnv());
        }
    }

    public boolean canSendMessage() {
        return BotController.INSTANCE != null && BotController.INSTANCE.isBotReady() && SDLinkConfig.INSTANCE != null;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public long getUptime() {
        return this.uptime;
    }
}

