/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.server;

import com.hypherionmc.craterlib.core.platform.CommonPlatform;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Member;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.events.message.MessageReceivedEvent;
import com.mojang.authlib.GameProfile;
import fabric.com.hypherionmc.sdlink.SDLinkConstants;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.database.SDLinkAccount;
import fabric.com.hypherionmc.sdlink.core.managers.DatabaseManager;
import fabric.com.hypherionmc.sdlink.core.messaging.Result;
import fabric.com.hypherionmc.sdlink.core.services.helpers.IMinecraftHelper;
import fabric.com.hypherionmc.sdlink.platform.SDLinkMCPlatform;
import fabric.com.hypherionmc.sdlink.server.ServerEvents;
import fabric.com.hypherionmc.sdlink.util.SDLinkChatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SDLinkMinecraftBridge
implements IMinecraftHelper {
    final Pattern patternStart = Pattern.compile("%(.*?)(?:\\|(.*?))?%", 2);

    @Override
    public void discordMessageReceived(Member member, String s1) {
        block16: {
            AtomicReference<String> user;
            block15: {
                if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                    SDLinkConstants.LOGGER.info("Got message {} from {}", (Object)s1, (Object)member.getEffectiveName());
                }
                user = new AtomicReference<String>(member.getEffectiveName());
                try {
                    if (DatabaseManager.sdlinkDatabase != null) {
                        List<SDLinkAccount> accounts = DatabaseManager.sdlinkDatabase.getCollection(SDLinkAccount.class);
                        accounts.stream().filter(a -> a.getDiscordID().equals(member.getId())).findFirst().ifPresent(u -> user.set(u.getUsername()));
                    }
                }
                catch (Exception e) {
                    if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block15;
                    SDLinkConstants.LOGGER.error("Failed to load account database: {}", (Object)e.getMessage());
                }
            }
            String prefix = SDLinkConfig.INSTANCE.messageFormatting.mcPrefix;
            class_5250 component = class_2561.method_43473();
            class_2583 baseStyle = class_2583.field_24360;
            Matcher matcher = this.patternStart.matcher(prefix);
            int lastAppendPosition = 0;
            while (matcher.find()) {
                String var = matcher.group(1);
                component.method_10852((class_2561)class_2561.method_43470((String)prefix.substring(lastAppendPosition, matcher.start())).method_27696(baseStyle));
                lastAppendPosition = matcher.end();
                if (var == null) continue;
                switch (var) {
                    case "color": {
                        baseStyle = baseStyle.method_27703(class_5251.method_27717((int)member.getColorRaw()));
                        break;
                    }
                    case "end_color": {
                        baseStyle = baseStyle.method_10977(class_124.field_1068);
                    }
                }
                if (!var.equalsIgnoreCase("user")) continue;
                component.method_27693(user.get()).method_27696(baseStyle);
            }
            component.method_10852((class_2561)class_2561.method_43470((String)prefix.substring(lastAppendPosition)).method_27696(baseStyle));
            try {
                class_5250 finalComponent = component.method_10852((class_2561)SDLinkChatUtils.parseChatLinks(s1));
                ServerEvents.getInstance().getMinecraftServer().method_3760().method_43514((class_2561)finalComponent, false);
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block16;
                SDLinkConstants.LOGGER.error("Failed to send message: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public Result checkWhitelisting() {
        boolean enabled = ServerEvents.getInstance().getMinecraftServer().method_3760().method_14614();
        return enabled ? Result.success("Server is using whitelisting") : Result.error("Server side whitelisting is disabled");
    }

    @Override
    public Pair<Integer, Integer> getPlayerCounts() {
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        return Pair.of((Object)server.method_3760().method_14574(), (Object)server.method_3760().method_14592());
    }

    @Override
    public List<MinecraftAccount> getOnlinePlayers() {
        ArrayList<MinecraftAccount> accounts = new ArrayList<MinecraftAccount>();
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        if (server != null && server.method_3760() != null) {
            server.method_3760().method_14571().forEach(p -> {
                MinecraftAccount account = MinecraftAccount.of(p.method_7334());
                accounts.add(account);
            });
        }
        return accounts;
    }

    @Override
    public long getServerUptime() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - ServerEvents.getInstance().getUptime());
    }

    @Override
    public String getServerVersion() {
        MinecraftServer server = ServerEvents.getInstance().getMinecraftServer();
        if (server == null) {
            return "Unknown - Unknown";
        }
        return server.getServerModName() + " - " + class_155.method_16673().method_48019();
    }

    @Override
    public Result executeMinecraftCommand(String command, int permLevel, MessageReceivedEvent event, @Nullable SDLinkAccount account) {
        String name = event.getMember().getEffectiveName();
        if (account != null) {
            name = account.getUsername();
        }
        command = command.replace("%linked_user%", name);
        command = command.replace("%role%", event.getMember().getRoles().stream().map(Role::getName).collect(Collectors.joining()));
        return SDLinkMCPlatform.INSTANCE.executeCommand(command, permLevel, event, name);
    }

    @Override
    public boolean isOnlineMode() {
        MinecraftServer server = CommonPlatform.INSTANCE.getMCServer();
        if (server == null) {
            return false;
        }
        if (ModloaderEnvironment.INSTANCE.isModLoaded("fabrictailor")) {
            return true;
        }
        return server.method_3828();
    }

    @Override
    public void banPlayer(MinecraftAccount minecraftAccount) {
        MinecraftServer server = CommonPlatform.INSTANCE.getMCServer();
        if (server == null) {
            return;
        }
        GameProfile profile = new GameProfile(minecraftAccount.getUuid(), minecraftAccount.getUsername());
        server.method_3760().method_14563().method_14633((class_3330)new class_3336(profile));
    }
}

