/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.networking;

import com.hypherionmc.craterlib.core.abstraction.server.AbstractFriendlyByteBuff;
import com.hypherionmc.craterlib.core.network.CraterPacket;
import fabric.com.hypherionmc.sdlink.client.ClientEvents;
import fabric.com.hypherionmc.sdlink.client.MentionsController;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MentionsSyncPacket
implements CraterPacket<MentionsSyncPacket> {
    private HashMap<String, String> roles;
    private HashMap<String, String> channelHashMap;
    private HashMap<String, String> users;
    private boolean mentionsEnabled = false;

    public MentionsSyncPacket() {
    }

    public MentionsSyncPacket(HashMap<String, String> roles, HashMap<String, String> channels, HashMap<String, String> users) {
        this.roles = roles;
        this.channelHashMap = channels;
        this.users = users;
    }

    public void write(class_2540 friendlyByteBuf) {
        class_2487 tag = new class_2487();
        class_2487 rolesTag = new class_2487();
        class_2487 channelsTag = new class_2487();
        class_2487 usersTag = new class_2487();
        this.roles.forEach((arg_0, arg_1) -> ((class_2487)rolesTag).method_10582(arg_0, arg_1));
        this.channelHashMap.forEach((arg_0, arg_1) -> ((class_2487)channelsTag).method_10582(arg_0, arg_1));
        this.users.forEach((arg_0, arg_1) -> ((class_2487)usersTag).method_10582(arg_0, arg_1));
        tag.method_10566("roles", (class_2520)rolesTag);
        tag.method_10566("channels", (class_2520)channelsTag);
        tag.method_10566("users", (class_2520)usersTag);
        tag.method_10556("mentionsenabled", SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat);
        AbstractFriendlyByteBuff.write((class_2540)friendlyByteBuf, (class_2487)tag);
    }

    public void read(class_2540 friendlyByteBuf) {
        class_2487 tag = friendlyByteBuf.method_10798();
        if (tag == null) {
            return;
        }
        class_2487 rolesTag = tag.method_10562("roles");
        class_2487 channelsTag = tag.method_10562("channels");
        class_2487 usersTag = tag.method_10562("users");
        this.roles = new HashMap();
        rolesTag.method_10541().forEach(k -> this.roles.put((String)k, rolesTag.method_10558(k)));
        this.channelHashMap = new HashMap();
        channelsTag.method_10541().forEach(k -> this.channelHashMap.put((String)k, channelsTag.method_10558(k)));
        this.users = new HashMap();
        usersTag.method_10541().forEach(k -> this.users.put((String)k, usersTag.method_10558(k)));
        this.mentionsEnabled = tag.method_10577("mentionsenabled");
    }

    public CraterPacket.PacketHandler<MentionsSyncPacket> createHandler() {
        return new CraterPacket.PacketHandler<MentionsSyncPacket>(){

            public void handle(MentionsSyncPacket mentionsSyncPacket, class_1657 player, Object o) {
                if (MentionsSyncPacket.this.roles != null && !MentionsSyncPacket.this.roles.isEmpty()) {
                    class_2960 rrl = new class_2960("sdlink:roles");
                    MentionsController.registerMention(rrl, MentionsSyncPacket.this.roles.keySet(), currentWord -> currentWord.startsWith("[@") || currentWord.startsWith("@"));
                }
                if (MentionsSyncPacket.this.channelHashMap != null && !MentionsSyncPacket.this.channelHashMap.isEmpty()) {
                    class_2960 crl = new class_2960("sdlink:channels");
                    MentionsController.registerMention(crl, MentionsSyncPacket.this.channelHashMap.keySet(), currentWord -> currentWord.startsWith("[#") || currentWord.startsWith("#"));
                }
                if (MentionsSyncPacket.this.users != null && !MentionsSyncPacket.this.users.isEmpty()) {
                    class_2960 url = new class_2960("sdlink:users");
                    MentionsController.registerMention(url, MentionsSyncPacket.this.users.keySet(), currentWord -> currentWord.startsWith("[@") || currentWord.startsWith("@"));
                }
                ClientEvents.mentionsEnabled = MentionsSyncPacket.this.mentionsEnabled;
            }
        };
    }
}

