/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.messaging.discord;

import fabric.com.hypherionmc.sdlink.core.accounts.DiscordAuthor;
import fabric.com.hypherionmc.sdlink.core.accounts.DiscordUser;
import fabric.com.hypherionmc.sdlink.core.accounts.MinecraftAccount;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.config.impl.MessageIgnoreConfig;
import fabric.com.hypherionmc.sdlink.core.messaging.MessageType;
import fabric.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessage;

public final class DiscordMessageBuilder {
    private final MessageType messageType;
    private DiscordAuthor author;
    private String message;
    private Runnable afterSend;

    public DiscordMessageBuilder(MessageType messageType) {
        this.messageType = messageType;
    }

    public DiscordMessageBuilder author(DiscordAuthor author) {
        this.author = author;
        if (author.getUsername().equalsIgnoreCase("server")) {
            this.author = DiscordAuthor.SERVER;
        }
        if (SDLinkConfig.INSTANCE.chatConfig.useLinkedNames && this.author != DiscordAuthor.SERVER) {
            MinecraftAccount account = author.getProfile() != null ? MinecraftAccount.of(author.getProfile()) : MinecraftAccount.of(author.getUsername());
            DiscordUser discordUser = account.getDiscordUser();
            if (account != null && discordUser != null) {
                this.author = DiscordAuthor.of(discordUser.getEffectiveName(), discordUser.getAvatarUrl(), author.getUsername(), false);
            }
        }
        return this;
    }

    public DiscordMessageBuilder message(String message) {
        if (this.messageType == MessageType.CHAT) {
            message = message.replace("@everyone", "");
            message = message.replace("@here", "");
            if (!SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                message = message.replace("<@", "");
            }
        }
        if (SDLinkConfig.INSTANCE.ignoreConfig.enabled) {
            for (MessageIgnoreConfig.Ignore i : SDLinkConfig.INSTANCE.ignoreConfig.entries) {
                if (i.searchMode == MessageIgnoreConfig.FilterMode.MATCHES && message.equalsIgnoreCase(i.search)) {
                    message = i.action == MessageIgnoreConfig.ActionMode.REPLACE ? message.replace(i.search, i.replace) : "";
                }
                if (i.searchMode == MessageIgnoreConfig.FilterMode.CONTAINS && message.contains(i.search)) {
                    message = i.action == MessageIgnoreConfig.ActionMode.REPLACE ? message.replace(i.search, i.replace) : "";
                }
                if (i.searchMode != MessageIgnoreConfig.FilterMode.STARTS_WITH || !message.startsWith(i.search)) continue;
                if (i.action == MessageIgnoreConfig.ActionMode.REPLACE) {
                    message = message.replace(i.search, i.replace);
                    continue;
                }
                message = "";
            }
        }
        this.message = message;
        return this;
    }

    public DiscordMessageBuilder afterSend(Runnable afterSend) {
        this.afterSend = afterSend;
        return this;
    }

    public DiscordMessage build() {
        if (this.author == null) {
            this.author = DiscordAuthor.SERVER;
        }
        if (this.message == null) {
            this.message = "";
        }
        return new DiscordMessage(this);
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public DiscordAuthor getAuthor() {
        return this.author;
    }

    public Runnable getAfterSend() {
        return this.afterSend;
    }
}

