/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.messaging.discord;

import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.WebhookClient;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookEmbed;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.MessageEmbed;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.data.DataArray;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.data.DataObject;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import com.hypherionmc.sdlink.shaded.javax.annotation.Nonnull;
import fabric.com.hypherionmc.sdlink.core.accounts.DiscordAuthor;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.config.impl.MessageChannelConfig;
import fabric.com.hypherionmc.sdlink.core.discord.BotController;
import fabric.com.hypherionmc.sdlink.core.managers.ChannelManager;
import fabric.com.hypherionmc.sdlink.core.managers.EmbedManager;
import fabric.com.hypherionmc.sdlink.core.managers.WebhookManager;
import fabric.com.hypherionmc.sdlink.core.messaging.MessageType;
import fabric.com.hypherionmc.sdlink.core.messaging.discord.DiscordMessageBuilder;
import fabric.com.hypherionmc.sdlink.core.util.SDLinkUtils;
import java.awt.Color;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.tuple.Triple;

public final class DiscordMessage {
    private final MessageType messageType;
    private final DiscordAuthor author;
    private final String message;
    private final Runnable afterSend;

    DiscordMessage(DiscordMessageBuilder builder) {
        this.messageType = builder.getMessageType();
        this.author = builder.getAuthor();
        this.message = builder.getMessage();
        this.afterSend = builder.getAfterSend();
    }

    public void sendMessage() {
        block6: {
            if (!BotController.INSTANCE.isBotReady()) {
                return;
            }
            if (this.message.isEmpty()) {
                return;
            }
            try {
                if (this.messageType == MessageType.CONSOLE) {
                    this.sendConsoleMessage();
                } else {
                    this.sendNormalMessage();
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block6;
                BotController.INSTANCE.getLogger().error("Failed to send Discord Message", (Throwable)e);
            }
        }
    }

    private void sendNormalMessage() {
        Triple<StandardGuildMessageChannel, WebhookClient, MessageChannelConfig.DestinationObject> channel = this.resolveDestination();
        if (channel.getMiddle() != null && SDLinkConfig.INSTANCE.channelsAndWebhooks.webhooks.enabled) {
            WebhookMessageBuilder builder = new WebhookMessageBuilder();
            builder.setUsername(this.author.getDisplayName());
            if (!this.author.getAvatar().isEmpty()) {
                builder.setAvatarUrl(this.author.getAvatar());
            }
            if (((MessageChannelConfig.DestinationObject)channel.getRight()).useEmbed) {
                EmbedBuilder eb = this.buildEmbed(false, ((MessageChannelConfig.DestinationObject)channel.getRight()).embedLayout);
                WebhookEmbed web = WebhookEmbedBuilder.fromJDA(eb.build()).build();
                builder.addEmbeds(web);
            } else {
                builder.setContent(this.message);
            }
            ((WebhookClient)channel.getMiddle()).send(builder.build()).thenRun(() -> {
                if (this.afterSend != null) {
                    this.afterSend.run();
                }
            });
        } else if (((MessageChannelConfig.DestinationObject)channel.getRight()).useEmbed) {
            EmbedBuilder eb = this.buildEmbed(true, ((MessageChannelConfig.DestinationObject)channel.getRight()).embedLayout);
            ((StandardGuildMessageChannel)channel.getLeft()).sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue(success -> {
                if (this.afterSend != null) {
                    this.afterSend.run();
                }
            });
        } else {
            ((StandardGuildMessageChannel)channel.getLeft()).sendMessage(this.messageType == MessageType.CHAT ? SDLinkConfig.INSTANCE.messageFormatting.chat.replace("%player%", this.author.getDisplayName()).replace("%message%", this.message) : this.message).queue(success -> {
                if (this.afterSend != null) {
                    this.afterSend.run();
                }
            });
        }
    }

    private void sendConsoleMessage() {
        block5: {
            try {
                if (!BotController.INSTANCE.isBotReady() || !SDLinkConfig.INSTANCE.chatConfig.sendConsoleMessages) {
                    return;
                }
                StandardGuildMessageChannel channel = ChannelManager.getConsoleChannel();
                if (channel != null) {
                    channel.sendMessage(this.message).queue();
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block5;
                BotController.INSTANCE.getLogger().error("Failed to send console message", (Throwable)e);
            }
        }
        if (this.afterSend != null) {
            this.afterSend.run();
        }
    }

    private EmbedBuilder buildEmbed(boolean withAuthor, String key) {
        String embedJson = EmbedManager.getEmbed(key);
        if (embedJson == null || embedJson.isEmpty()) {
            EmbedBuilder builder = new EmbedBuilder();
            if (withAuthor) {
                builder.setAuthor(this.author.getDisplayName(), null, this.author.getAvatar().isEmpty() ? null : this.author.getAvatar());
            }
            builder.setDescription(this.message);
            return builder;
        }
        embedJson = embedJson.replace("%author%", this.author.getDisplayName()).replace("%avatar%", this.author.getAvatar()).replace("%message_contents%", this.message).replace("%player_avatar%", this.author.getRealPlayerAvatar()).replace("%player_name%", this.author.getRealPlayerName()).replace("%username%", this.author.getUsername());
        DataObject object = DataObject.fromJson(embedJson);
        return this.fromData(object);
    }

    private Triple<StandardGuildMessageChannel, WebhookClient, MessageChannelConfig.DestinationObject> resolveDestination() {
        switch (this.messageType) {
            case CHAT: {
                MessageChannelConfig.DestinationObject chat = SDLinkConfig.INSTANCE.messageDestinations.chat;
                return Triple.of((Object)ChannelManager.getDestinationChannel(chat.channel), (Object)WebhookManager.getWebhookClient(chat.channel), (Object)chat);
            }
            case START: {
                MessageChannelConfig.DestinationObject startStop = SDLinkConfig.INSTANCE.messageDestinations.start;
                return Triple.of((Object)ChannelManager.getDestinationChannel(startStop.channel), (Object)WebhookManager.getWebhookClient(startStop.channel), (Object)startStop);
            }
            case STOP: {
                MessageChannelConfig.DestinationObject startStop = SDLinkConfig.INSTANCE.messageDestinations.stop;
                return Triple.of((Object)ChannelManager.getDestinationChannel(startStop.channel), (Object)WebhookManager.getWebhookClient(startStop.channel), (Object)startStop);
            }
            case JOIN: {
                MessageChannelConfig.DestinationObject joinLeave = SDLinkConfig.INSTANCE.messageDestinations.join;
                return Triple.of((Object)ChannelManager.getDestinationChannel(joinLeave.channel), (Object)WebhookManager.getWebhookClient(joinLeave.channel), (Object)joinLeave);
            }
            case LEAVE: {
                MessageChannelConfig.DestinationObject joinLeave = SDLinkConfig.INSTANCE.messageDestinations.leave;
                return Triple.of((Object)ChannelManager.getDestinationChannel(joinLeave.channel), (Object)WebhookManager.getWebhookClient(joinLeave.channel), (Object)joinLeave);
            }
            case ADVANCEMENT: {
                MessageChannelConfig.DestinationObject advancement = SDLinkConfig.INSTANCE.messageDestinations.advancements;
                return Triple.of((Object)ChannelManager.getDestinationChannel(advancement.channel), (Object)WebhookManager.getWebhookClient(advancement.channel), (Object)advancement);
            }
            case DEATH: {
                MessageChannelConfig.DestinationObject death = SDLinkConfig.INSTANCE.messageDestinations.death;
                return Triple.of((Object)ChannelManager.getDestinationChannel(death.channel), (Object)WebhookManager.getWebhookClient(death.channel), (Object)death);
            }
            case COMMAND: {
                MessageChannelConfig.DestinationObject command = SDLinkConfig.INSTANCE.messageDestinations.commands;
                return Triple.of((Object)ChannelManager.getDestinationChannel(command.channel), (Object)WebhookManager.getWebhookClient(command.channel), (Object)command);
            }
            case CUSTOM: {
                MessageChannelConfig.DestinationObject custom = SDLinkConfig.INSTANCE.messageDestinations.custom;
                return Triple.of((Object)ChannelManager.getDestinationChannel(custom.channel), (Object)WebhookManager.getWebhookClient(custom.channel), (Object)custom);
            }
        }
        MessageChannelConfig.DestinationObject chat = SDLinkConfig.INSTANCE.messageDestinations.chat;
        return Triple.of((Object)ChannelManager.getDestinationChannel(chat.channel), (Object)WebhookManager.getWebhookClient(chat.channel), (Object)chat);
    }

    @Nonnull
    private EmbedBuilder fromData(@Nonnull DataObject data) {
        Checks.notNull(data, "DataObject");
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle(data.getString("title", null));
        builder.setUrl(data.getString("url", null));
        builder.setDescription(data.getString("description", ""));
        if (!data.isNull("timestamp") && !data.getString("timestamp").equalsIgnoreCase("0")) {
            builder.setTimestamp(OffsetDateTime.parse(data.getString("timestamp")));
        }
        if (data.getString("color", "#000000").startsWith("#")) {
            builder.setColor(Color.decode(data.getString("color", "#000000")));
        } else {
            builder.setColor(data.getInt("color", 0x1FFFFFFF));
        }
        data.optObject("thumbnail").ifPresent(thumbnail -> builder.setThumbnail(SDLinkUtils.isNullOrEmpty(thumbnail.getString("url")) ? null : thumbnail.getString("url")));
        data.optObject("author").ifPresent(author -> builder.setAuthor(author.getString("name", ""), SDLinkUtils.isNullOrEmpty(author.getString("url", null)) ? null : author.getString("url", null), SDLinkUtils.isNullOrEmpty(author.getString("icon_url", null)) ? null : author.getString("icon_url", null)));
        data.optObject("footer").ifPresent(footer -> builder.setFooter(footer.getString("text", ""), SDLinkUtils.isNullOrEmpty(footer.getString("icon_url", null)) ? null : footer.getString("icon_url", null)));
        data.optObject("image").ifPresent(image -> builder.setImage(SDLinkUtils.isNullOrEmpty(image.getString("url")) ? null : image.getString("url")));
        data.optArray("fields").ifPresent(arr -> arr.stream(DataArray::getObject).forEach(field -> builder.addField(field.getString("name", "\u200e"), field.getString("value", "\u200e"), field.getBoolean("inline", false))));
        return builder;
    }
}

