/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hypherionmc.sdlink.core.managers;

import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import fabric.com.hypherionmc.sdlink.core.config.SDLinkConfig;
import fabric.com.hypherionmc.sdlink.core.discord.BotController;
import fabric.com.hypherionmc.sdlink.core.util.SDLinkUtils;
import fabric.com.hypherionmc.sdlink.core.util.SystemUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RoleManager {
    private static final Set<Role> verificationRoles = new HashSet<Role>();
    private static final Set<Role> deniedRoles = new HashSet<Role>();
    private static Role verifiedRole = null;

    public static void loadRequiredRoles(AtomicInteger errCount, StringBuilder builder) {
        if (SDLinkConfig.INSTANCE.accessControl.enabled) {
            SDLinkConfig.INSTANCE.accessControl.requiredRoles.forEach(r -> {
                Role role = RoleManager.getRole(errCount, builder, "Access Control Role", r);
                if (role != null) {
                    verificationRoles.add(role);
                }
            });
            SDLinkConfig.INSTANCE.accessControl.deniedRoles.forEach(r -> {
                Role role = RoleManager.getRole(errCount, builder, "Access Control Role", r);
                if (role != null) {
                    deniedRoles.add(role);
                }
            });
            if (!SDLinkUtils.isNullOrEmpty(SDLinkConfig.INSTANCE.accessControl.verifiedRole)) {
                verifiedRole = RoleManager.getRole(errCount, builder, "Verified Player Role", SDLinkConfig.INSTANCE.accessControl.verifiedRole);
            }
        }
    }

    private static Role getRole(AtomicInteger errCount, StringBuilder builder, String roleIdentifier, String roleID) {
        Role role = null;
        if (SystemUtils.isLong(roleID)) {
            role = BotController.INSTANCE.getJDA().getRoleById(roleID);
        }
        if (role != null) {
            return role;
        }
        List<Role> roles = BotController.INSTANCE.getJDA().getRolesByName(roleID, true);
        if (!roles.isEmpty()) {
            return roles.get(0);
        }
        errCount.incrementAndGet();
        builder.append(errCount.get()).append(") ").append("Missing ").append(roleIdentifier).append(" Role. Role: ").append(roleID).append(" cannot be found in the server").append("\r\n");
        return null;
    }

    public static Set<Role> getVerificationRoles() {
        return verificationRoles;
    }

    public static Role getVerifiedRole() {
        return verifiedRole;
    }

    public static Set<Role> getDeniedRoles() {
        return deniedRoles;
    }
}

